/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.http.annotation.parser;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import eu.cloudnetservice.common.StringUtil;
import eu.cloudnetservice.common.document.gson.JsonDocument;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.driver.network.http.HttpComponent;
import eu.cloudnetservice.driver.network.http.HttpContext;
import eu.cloudnetservice.driver.network.http.HttpContextPreprocessor;
import eu.cloudnetservice.driver.network.http.annotation.FirstRequestQueryParam;
import eu.cloudnetservice.driver.network.http.annotation.HttpRequestHandler;
import eu.cloudnetservice.driver.network.http.annotation.Optional;
import eu.cloudnetservice.driver.network.http.annotation.RequestBody;
import eu.cloudnetservice.driver.network.http.annotation.RequestHeader;
import eu.cloudnetservice.driver.network.http.annotation.RequestPath;
import eu.cloudnetservice.driver.network.http.annotation.RequestPathParam;
import eu.cloudnetservice.driver.network.http.annotation.RequestQueryParam;
import eu.cloudnetservice.driver.network.http.annotation.parser.AnnotationHttpHandleException;
import eu.cloudnetservice.driver.network.http.annotation.parser.HttpAnnotationParser;
import eu.cloudnetservice.driver.network.http.annotation.parser.HttpAnnotationProcessor;
import eu.cloudnetservice.driver.network.http.annotation.parser.HttpAnnotationProcessorUtil;
import eu.cloudnetservice.driver.network.http.annotation.parser.MethodHttpHandlerInvoker;
import eu.cloudnetservice.driver.network.http.annotation.parser.ParameterInvocationHint;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public final class DefaultHttpAnnotationParser<T extends HttpComponent<T>>
implements HttpAnnotationParser<T> {
    public static final String DEFAULTS_TO_NULL_MASK = "__NULL__";
    public static final String PARAM_INVOCATION_HINT_KEY = "__PARAM_INVOCATION_HINT__";
    private final T component;
    private final Deque<HttpAnnotationProcessor> processors = new LinkedList<HttpAnnotationProcessor>();

    public DefaultHttpAnnotationParser(@NonNull T component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        this.component = component;
    }

    @Nullable
    private static Object applyDefault(@NonNull String defaultValue, @Nullable String actualValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        if (actualValue != null) {
            return actualValue;
        }
        return defaultValue.equals(DEFAULTS_TO_NULL_MASK) ? null : defaultValue;
    }

    @NonNull
    public static <T extends HttpComponent<T>> HttpAnnotationParser<T> withDefaultProcessors(@NonNull T com) {
        if (com == null) {
            throw new NullPointerException("com is marked non-null but is null");
        }
        return new DefaultHttpAnnotationParser<T>(com).registerDefaultProcessors();
    }

    @NonNull
    public HttpAnnotationParser<T> registerDefaultProcessors() {
        return this.registerAnnotationProcessor(new FirstRequestQueryParamProcessor()).registerAnnotationProcessor(new RequestBodyProcessor()).registerAnnotationProcessor(new RequestHeaderProcessor()).registerAnnotationProcessor(new RequestPathProcessor()).registerAnnotationProcessor(new RequestPathParamProcessor()).registerAnnotationProcessor(new RequestQueryParamProcessor());
    }

    @Override
    @NonNull
    public T httpComponent() {
        return this.component;
    }

    @Override
    public @UnmodifiableView @NonNull Collection<HttpAnnotationProcessor> annotationProcessors() {
        return Collections.unmodifiableCollection(this.processors);
    }

    @Override
    @NonNull
    public HttpAnnotationParser<T> registerAnnotationProcessor(@NonNull HttpAnnotationProcessor processor) {
        if (processor == null) {
            throw new NullPointerException("processor is marked non-null but is null");
        }
        this.processors.addFirst(processor);
        return this;
    }

    @Override
    @NonNull
    public HttpAnnotationParser<T> unregisterAnnotationProcessor(@NonNull HttpAnnotationProcessor processor) {
        if (processor == null) {
            throw new NullPointerException("processor is marked non-null but is null");
        }
        this.processors.remove(processor);
        return this;
    }

    @Override
    @NonNull
    public HttpAnnotationParser<T> unregisterAnnotationProcessors(@NonNull ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader is marked non-null but is null");
        }
        this.processors.removeIf(entry -> entry.getClass().getClassLoader() == classLoader);
        return this;
    }

    @Override
    @NonNull
    public HttpAnnotationParser<T> parseAndRegister(@NonNull Class<?> handlerClass) {
        if (handlerClass == null) {
            throw new NullPointerException("handlerClass is marked non-null but is null");
        }
        InjectionLayer<?> injectionLayer = InjectionLayer.findLayerOf(handlerClass);
        return this.parseAndRegister(injectionLayer.instance(handlerClass));
    }

    @Override
    @NonNull
    public HttpAnnotationParser<T> parseAndRegister(@NonNull Object handlerInstance) {
        if (handlerInstance == null) {
            throw new NullPointerException("handlerInstance is marked non-null but is null");
        }
        for (Method method : handlerInstance.getClass().getDeclaredMethods()) {
            Class<?>[] methodParameterTypes;
            HttpRequestHandler annotation = method.getAnnotation(HttpRequestHandler.class);
            if (annotation == null) continue;
            if (Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException(String.format("Http handler method (@HttpRequestHandler) %s in %s must not be static!", method.getName(), method.getDeclaringClass().getName()));
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                method.setAccessible(true);
            }
            if ((methodParameterTypes = method.getParameterTypes()).length == 0 || !HttpContext.class.isAssignableFrom(methodParameterTypes[0])) {
                throw new IllegalArgumentException(String.format("Http handler method (@HttpRequestHandler) %s in %s must take HttpContext as the first argument!", method.getName(), method.getDeclaringClass().getName()));
            }
            String[] supportedPaths = annotation.paths();
            Integer boundPort = annotation.port() >= 0 && annotation.port() <= 65535 ? Integer.valueOf(annotation.port()) : null;
            List<String> supportedMethods = Arrays.stream(annotation.methods()).map(StringUtil::toUpper).toList();
            Preconditions.checkArgument((supportedPaths.length > 0 ? 1 : 0) != 0, (Object)"At least one path to handle must be present");
            Preconditions.checkArgument((!supportedMethods.isEmpty() ? 1 : 0) != 0, (Object)"At least one method to handle must be present");
            try {
                MethodHttpHandlerInvoker handler = new MethodHttpHandlerInvoker(handlerInstance, method, supportedMethods);
                for (HttpAnnotationProcessor processor : this.processors) {
                    HttpContextPreprocessor contextProcessor;
                    if (!processor.shouldProcess(method, handlerInstance) || (contextProcessor = processor.buildPreprocessor(method, handlerInstance)) == null) continue;
                    handler.addPreProcessorHead(contextProcessor);
                }
                for (String path : supportedPaths) {
                    this.component.registerHandler(path, boundPort, annotation.priority(), handler);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return this;
    }

    private static final class FirstRequestQueryParamProcessor
    implements HttpAnnotationProcessor {
        private FirstRequestQueryParamProcessor() {
        }

        @Override
        @NonNull
        public HttpContextPreprocessor buildPreprocessor(@NonNull Method method, @NonNull Object handler) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            Collection<ParameterInvocationHint> hints = HttpAnnotationProcessorUtil.mapParameters(method, FirstRequestQueryParam.class, (param, annotation) -> (path, context) -> {
                List<String> queryParameters = context.request().queryParameters().get(annotation.value());
                if (!param.isAnnotationPresent(Optional.class) && (queryParameters == null || queryParameters.isEmpty())) {
                    throw new AnnotationHttpHandleException((String)path, "Missing required query param: " + annotation.value());
                }
                return DefaultHttpAnnotationParser.applyDefault(annotation.def(), queryParameters == null ? null : (String)Iterables.getFirst(queryParameters, null));
            });
            return (path, context) -> context.addInvocationHints(DefaultHttpAnnotationParser.PARAM_INVOCATION_HINT_KEY, hints);
        }
    }

    private static final class RequestBodyProcessor
    implements HttpAnnotationProcessor {
        private RequestBodyProcessor() {
        }

        @Override
        @NonNull
        public HttpContextPreprocessor buildPreprocessor(@NonNull Method method, @NonNull Object handler) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            Collection<ParameterInvocationHint> hints = HttpAnnotationProcessorUtil.mapParameters(method, RequestBody.class, (param, annotation) -> (path, context) -> {
                if (String.class.isAssignableFrom(param.getType())) {
                    return context.request().bodyAsString();
                }
                if (byte[].class.isAssignableFrom(param.getType())) {
                    return context.request().body();
                }
                if (InputStream.class.isAssignableFrom(param.getType())) {
                    return context.request().bodyStream();
                }
                if (JsonDocument.class.isAssignableFrom(param.getType())) {
                    return JsonDocument.newDocument((InputStream)context.request().bodyStream());
                }
                throw new AnnotationHttpHandleException((String)path, "Unable to inject body of type " + param.getType().getName());
            });
            return (path, context) -> context.addInvocationHints(DefaultHttpAnnotationParser.PARAM_INVOCATION_HINT_KEY, hints);
        }
    }

    private static final class RequestHeaderProcessor
    implements HttpAnnotationProcessor {
        private RequestHeaderProcessor() {
        }

        @Override
        @NonNull
        public HttpContextPreprocessor buildPreprocessor(@NonNull Method method, @NonNull Object handler) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            Collection<ParameterInvocationHint> hints = HttpAnnotationProcessorUtil.mapParameters(method, RequestHeader.class, (param, annotation) -> (path, context) -> {
                String header = context.request().header(annotation.value());
                if (!param.isAnnotationPresent(Optional.class) && header == null) {
                    throw new AnnotationHttpHandleException((String)path, "Missing required header: " + annotation.value());
                }
                return DefaultHttpAnnotationParser.applyDefault(annotation.def(), header);
            });
            return (path, context) -> context.addInvocationHints(DefaultHttpAnnotationParser.PARAM_INVOCATION_HINT_KEY, hints);
        }
    }

    private static final class RequestPathProcessor
    implements HttpAnnotationProcessor {
        private RequestPathProcessor() {
        }

        @Override
        @NonNull
        public HttpContextPreprocessor buildPreprocessor(@NonNull Method method, @NonNull Object handler) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            Collection<ParameterInvocationHint> hints = HttpAnnotationProcessorUtil.mapParameters(method, RequestPath.class, (param, annotation) -> (path, context) -> path);
            return (path, context) -> context.addInvocationHints(DefaultHttpAnnotationParser.PARAM_INVOCATION_HINT_KEY, hints);
        }
    }

    private static final class RequestPathParamProcessor
    implements HttpAnnotationProcessor {
        private RequestPathParamProcessor() {
        }

        @Override
        @NonNull
        public HttpContextPreprocessor buildPreprocessor(@NonNull Method method, @NonNull Object handler) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            Collection<ParameterInvocationHint> hints = HttpAnnotationProcessorUtil.mapParameters(method, RequestPathParam.class, (param, annotation) -> (path, context) -> {
                String pathParam = context.request().pathParameters().get(annotation.value());
                if (!param.isAnnotationPresent(Optional.class) && pathParam == null) {
                    throw new AnnotationHttpHandleException((String)path, "Missing required path parameter: " + annotation.value());
                }
                return pathParam;
            });
            return (path, context) -> context.addInvocationHints(DefaultHttpAnnotationParser.PARAM_INVOCATION_HINT_KEY, hints);
        }
    }

    private static final class RequestQueryParamProcessor
    implements HttpAnnotationProcessor {
        private RequestQueryParamProcessor() {
        }

        @Override
        @NonNull
        public HttpContextPreprocessor buildPreprocessor(@NonNull Method method, @NonNull Object handler) {
            if (method == null) {
                throw new NullPointerException("method is marked non-null but is null");
            }
            if (handler == null) {
                throw new NullPointerException("handler is marked non-null but is null");
            }
            Collection<ParameterInvocationHint> hints = HttpAnnotationProcessorUtil.mapParameters(method, RequestQueryParam.class, (param, annotation) -> (path, context) -> {
                List<String> queryParameters = context.request().queryParameters().get(annotation.value());
                if (!param.isAnnotationPresent(Optional.class) && (queryParameters == null || queryParameters.isEmpty())) {
                    throw new AnnotationHttpHandleException((String)path, "Missing required query param: " + annotation.value());
                }
                return (queryParameters == null || queryParameters.isEmpty()) && annotation.nullWhenAbsent() ? null : Objects.requireNonNullElse(queryParameters, List.of());
            });
            return (path, context) -> context.addInvocationHints(DefaultHttpAnnotationParser.PARAM_INVOCATION_HINT_KEY, hints);
        }
    }
}

