/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.http.annotation.parser;

import eu.cloudnetservice.driver.network.http.HttpHandleException;
import eu.cloudnetservice.driver.network.http.HttpResponseCode;
import lombok.NonNull;

public final class AnnotationHttpHandleException
extends HttpHandleException {
    public AnnotationHttpHandleException(@NonNull String path, @NonNull String reason) {
        this(path, reason, HttpResponseCode.BAD_REQUEST, null);
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
    }

    public AnnotationHttpHandleException(@NonNull String path, @NonNull String reason, @NonNull HttpResponseCode responseCode, byte[] responseBody) {
        super(responseCode, responseBody, String.format("Unable to handle http request on path \"%s\": %s", path, reason));
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
        if (responseCode == null) {
            throw new NullPointerException("responseCode is marked non-null but is null");
        }
    }
}

