/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.http;

import eu.cloudnetservice.common.Nameable;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class HttpCookie
implements Nameable {
    protected final String name;
    protected final String value;
    protected final String domain;
    protected final String path;
    protected final boolean httpOnly;
    protected final boolean secure;
    protected final boolean wrap;
    protected final long maxAge;

    public HttpCookie(@NonNull String name, @NonNull String value) {
        this(name, value, null, null, Long.MAX_VALUE);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
    }

    public HttpCookie(@NonNull String name, @NonNull String value, @Nullable String domain, @Nullable String path, long maxAge) {
        this(name, value, domain, path, false, false, false, maxAge);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
    }

    public HttpCookie(@NonNull String name, @NonNull String value, @Nullable String domain, @Nullable String path, boolean httpOnly, boolean secure, boolean wrap, long maxAge) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.name = name;
        this.value = value;
        this.domain = domain;
        this.path = path;
        this.httpOnly = httpOnly;
        this.secure = secure;
        this.wrap = wrap;
        this.maxAge = maxAge;
    }

    @NonNull
    public String name() {
        return this.name;
    }

    @NonNull
    public String value() {
        return this.value;
    }

    @Nullable
    public String domain() {
        return this.domain;
    }

    @Nullable
    public String path() {
        return this.path;
    }

    public long maxAge() {
        return this.maxAge;
    }

    public boolean httpOnly() {
        return this.httpOnly;
    }

    public boolean secure() {
        return this.secure;
    }

    public boolean wrap() {
        return this.wrap;
    }

    public String toString() {
        return "HttpCookie(name=" + this.name + ", value=" + this.value + ", domain=" + this.domain + ", path=" + this.path + ", httpOnly=" + this.httpOnly + ", secure=" + this.secure + ", wrap=" + this.wrap + ", maxAge=" + this.maxAge + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpCookie)) {
            return false;
        }
        HttpCookie other = (HttpCookie)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.httpOnly != other.httpOnly) {
            return false;
        }
        if (this.secure != other.secure) {
            return false;
        }
        if (this.wrap != other.wrap) {
            return false;
        }
        if (this.maxAge != other.maxAge) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$value = this.value;
        String other$value = other.value;
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$domain = this.domain;
        String other$domain = other.domain;
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$path = this.path;
        String other$path = other.path;
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpCookie;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.httpOnly ? 79 : 97);
        result = result * 59 + (this.secure ? 79 : 97);
        result = result * 59 + (this.wrap ? 79 : 97);
        long $maxAge = this.maxAge;
        result = result * 59 + (int)($maxAge >>> 32 ^ $maxAge);
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $domain = this.domain;
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $path = this.path;
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }
}

