/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.cluster;

import eu.cloudnetservice.common.document.gson.JsonDocument;
import eu.cloudnetservice.common.document.property.DefaultedDocPropertyHolder;
import eu.cloudnetservice.driver.network.HostAndPort;
import java.util.List;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public final class NetworkClusterNode
implements DefaultedDocPropertyHolder<JsonDocument, NetworkClusterNode> {
    private final String uniqueId;
    private final List<HostAndPort> listeners;
    private final JsonDocument properties;

    public NetworkClusterNode(@NonNull String uniqueId, @NonNull List<HostAndPort> listeners) {
        this(uniqueId, listeners, JsonDocument.newDocument());
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        if (listeners == null) {
            throw new NullPointerException("listeners is marked non-null but is null");
        }
    }

    public NetworkClusterNode(@NonNull String uniqueId, @NonNull List<HostAndPort> listeners, @NonNull JsonDocument properties) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        if (listeners == null) {
            throw new NullPointerException("listeners is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.uniqueId = uniqueId;
        this.listeners = listeners;
        this.properties = properties;
    }

    @NonNull
    public String uniqueId() {
        return this.uniqueId;
    }

    @NonNull
    public List<HostAndPort> listeners() {
        return this.listeners;
    }

    @NonNull
    public JsonDocument propertyHolder() {
        return this.properties;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NetworkClusterNode) {
            NetworkClusterNode other = (NetworkClusterNode)obj;
            return other.uniqueId().equals(this.uniqueId);
        }
        return false;
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    public String toString() {
        return "NetworkClusterNode(uniqueId=" + this.uniqueId + ", listeners=" + this.listeners + ", properties=" + this.properties + ")";
    }
}

