/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.chunk.network;

import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.chunk.data.ChunkSessionInformation;
import eu.cloudnetservice.driver.network.protocol.BasePacket;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class ChunkedPacket
extends BasePacket {
    public ChunkedPacket(@NonNull DataBuf dataBuf) {
        super(2, dataBuf);
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
    }

    @NonNull
    public static ChunkedPacket createChunk(@NonNull ChunkSessionInformation information, int chunkIndex, byte[] data) {
        if (information == null) {
            throw new NullPointerException("information is marked non-null but is null");
        }
        return ChunkedPacket.createChunk(information, null, chunkIndex, data.length, data);
    }

    @NonNull
    public static ChunkedPacket createChunk(@NonNull ChunkSessionInformation information, @Nullable Integer chunkAmount, int chunkIndex, int dataLength, byte[] data) {
        if (information == null) {
            throw new NullPointerException("information is marked non-null but is null");
        }
        DataBuf.Mutable dataBuf = DataBuf.empty().writeObject(information).writeInt(chunkIndex).writeBoolean(chunkAmount != null);
        if (chunkAmount != null) {
            dataBuf.writeInt(chunkAmount);
        }
        return new ChunkedPacket(dataBuf.writeByteArray(data, dataLength));
    }
}

