/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.chunk.defaults;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.common.io.FileUtil;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.chunk.ChunkedPacketHandler;
import eu.cloudnetservice.driver.network.chunk.TransferStatus;
import eu.cloudnetservice.driver.network.chunk.data.ChunkSessionInformation;
import eu.cloudnetservice.driver.network.chunk.defaults.DefaultChunkedPacketProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class DefaultFileChunkedPacketHandler
extends DefaultChunkedPacketProvider
implements ChunkedPacketHandler {
    protected final Path tempFilePath;
    protected final RandomAccessFile targetFile;
    protected final ChunkedPacketHandler.Callback writeCompleteHandler;
    protected final Lock lock = new ReentrantLock(true);
    protected int writtenFileParts = -1;
    protected Integer expectedFileParts;

    public DefaultFileChunkedPacketHandler(@NonNull ChunkSessionInformation sessionInformation, @Nullable ChunkedPacketHandler.Callback completeHandler) {
        this(sessionInformation, completeHandler, FileUtil.createTempFile());
        if (sessionInformation == null) {
            throw new NullPointerException("sessionInformation is marked non-null but is null");
        }
    }

    public DefaultFileChunkedPacketHandler(@NonNull ChunkSessionInformation sessionInformation, @Nullable ChunkedPacketHandler.Callback completeHandler, @NonNull Path tempFilePath) {
        super(sessionInformation);
        if (sessionInformation == null) {
            throw new NullPointerException("sessionInformation is marked non-null but is null");
        }
        if (tempFilePath == null) {
            throw new NullPointerException("tempFilePath is marked non-null but is null");
        }
        this.tempFilePath = tempFilePath;
        this.writeCompleteHandler = completeHandler;
        try {
            if (Files.notExists(tempFilePath, new LinkOption[0])) {
                Files.createFile(tempFilePath, new FileAttribute[0]);
            }
            this.targetFile = new RandomAccessFile(this.tempFilePath.toFile(), "rwd");
        }
        catch (IOException exception) {
            throw new AssertionError("Unable to open raf to temp file, this should not happen", exception);
        }
    }

    @Override
    public boolean handleChunkPart(int chunkPosition, @NonNull DataBuf dataBuf) {
        InputStream inputStream2;
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        if (this.transferStatus == TransferStatus.FAILURE) {
            return false;
        }
        Preconditions.checkState((this.transferStatus == TransferStatus.RUNNING ? 1 : 0) != 0, (Object)"Received transfer part after success");
        boolean isFinalPacket = dataBuf.readBoolean();
        if (isFinalPacket) {
            this.expectedFileParts = dataBuf.readInt();
        }
        try {
            this.lock.lock();
            this.writePacketContent(chunkPosition, dataBuf);
            this.updateStatus();
            if (this.transferStatus == TransferStatus.SUCCESS) {
                this.targetFile.close();
                if (this.writeCompleteHandler == null) {
                    boolean bl = true;
                    return bl;
                }
                inputStream2 = Files.newInputStream(this.tempFilePath, StandardOpenOption.DELETE_ON_CLOSE);
                this.writeCompleteHandler.handleSessionComplete(this.chunkSessionInformation, inputStream2);
                boolean bl = true;
                return bl;
            }
            boolean inputStream2 = false;
            return inputStream2;
        }
        catch (IOException exception) {
            this.transferStatus = TransferStatus.FAILURE;
        }
        {
            finally {
                if (inputStream2 != null) {
                    inputStream2.close();
                }
            }
        }
        {
            throw new IllegalStateException("Unexpected exception handling chunk part", exception);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @NonNull
    public ChunkedPacketHandler.Callback callback() {
        return this.writeCompleteHandler;
    }

    protected void writePacketContent(int chunkPosition, @NonNull DataBuf dataBuf) throws IOException {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        int targetIndex = chunkPosition * this.chunkSessionInformation.chunkSize();
        this.targetFile.seek(targetIndex);
        this.targetFile.write(dataBuf.readByteArray());
        ++this.writtenFileParts;
    }

    protected void updateStatus() {
        if (this.transferStatus == TransferStatus.RUNNING && this.expectedFileParts != null && this.expectedFileParts == this.writtenFileParts) {
            this.transferStatus = TransferStatus.SUCCESS;
        }
    }
}

