/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.module;

import com.google.common.base.Preconditions;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDependency {
    private final String repo;
    private final String url;
    private final String group;
    private final String name;
    private final String version;
    private final String checksum;

    public ModuleDependency(@NonNull String group, @NonNull String name, @NonNull String version) {
        this(null, group, name, version);
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
    }

    public ModuleDependency(@Nullable String repo, @NonNull String group, @NonNull String name, @NonNull String version) {
        this(repo, null, group, name, version, null);
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
    }

    public ModuleDependency(@Nullable String repo, @Nullable String url, @NonNull String group, @NonNull String name, @NonNull String version, @Nullable String checksum) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        this.repo = repo;
        this.url = url;
        this.group = group;
        this.name = name;
        this.version = version;
        this.checksum = checksum;
    }

    @Nullable
    public String repo() {
        return this.repo;
    }

    @Nullable
    public String url() {
        return this.url;
    }

    @NonNull
    public String group() {
        return this.group;
    }

    @NonNull
    public String name() {
        return this.name;
    }

    @NonNull
    public String version() {
        return this.version;
    }

    @Nullable
    public String checksum() {
        return this.checksum;
    }

    public void assertDefaultPropertiesSet() {
        Preconditions.checkNotNull((Object)this.group, (Object)"Missing group of module dependency");
        Preconditions.checkNotNull((Object)this.name, (Object)"Missing name of module dependency");
        Preconditions.checkNotNull((Object)this.version, (Object)"Missing version of module dependency");
    }

    public String toString() {
        return this.group + ":" + this.name + ":" + this.version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuleDependency)) {
            return false;
        }
        ModuleDependency other = (ModuleDependency)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$repo = this.repo;
        String other$repo = other.repo;
        if (this$repo == null ? other$repo != null : !this$repo.equals(other$repo)) {
            return false;
        }
        String this$url = this.url;
        String other$url = other.url;
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$group = this.group;
        String other$group = other.group;
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.version;
        String other$version = other.version;
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$checksum = this.checksum;
        String other$checksum = other.checksum;
        return !(this$checksum == null ? other$checksum != null : !this$checksum.equals(other$checksum));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModuleDependency;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $repo = this.repo;
        result = result * 59 + ($repo == null ? 43 : $repo.hashCode());
        String $url = this.url;
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $group = this.group;
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.version;
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $checksum = this.checksum;
        result = result * 59 + ($checksum == null ? 43 : $checksum.hashCode());
        return result;
    }
}

