/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.module;

import eu.cloudnetservice.common.JavaVersion;
import eu.cloudnetservice.common.Nameable;
import eu.cloudnetservice.common.document.gson.JsonDocument;
import eu.cloudnetservice.common.io.FileUtil;
import eu.cloudnetservice.driver.module.ModuleDependency;
import eu.cloudnetservice.driver.module.ModuleRepository;
import java.nio.file.Path;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public record ModuleConfiguration(boolean runtimeModule, boolean storesSensitiveData, @NonNull String group, @NonNull String name, @NonNull String version, @NonNull String main, @Nullable String description, @Nullable String author, @Nullable String website, @Nullable String dataFolder, @Nullable ModuleRepository[] repositories, @Nullable ModuleDependency[] dependencies, int minJavaVersionId, @Nullable JsonDocument properties) implements Nameable
{
    public ModuleConfiguration(boolean runtimeModule, boolean storesSensitiveData, @NonNull String group, @NonNull String name, @NonNull String version, @NonNull String main, @Nullable String description, @Nullable String author, @Nullable String website, @Nullable String dataFolder, @Nullable ModuleRepository[] repositories, @Nullable ModuleDependency[] dependencies, int minJavaVersionId, @Nullable JsonDocument properties) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (main == null) {
            throw new NullPointerException("main is marked non-null but is null");
        }
    }

    @NonNull
    public Path dataFolder(@NonNull Path baseDirectory) {
        if (baseDirectory == null) {
            throw new NullPointerException("baseDirectory is marked non-null but is null");
        }
        if (this.dataFolder == null) {
            return baseDirectory.resolve(this.name);
        }
        return FileUtil.resolve((Path)Path.of("", new String[0]), (String[])this.dataFolder.split("/"));
    }

    @Nullable
    public JavaVersion minJavaVersion() {
        return this.minJavaVersionId > 0 ? JavaVersion.guessFromMajor((int)this.minJavaVersionId) : null;
    }

    public boolean canRunOn(@NonNull JavaVersion javaVersion) {
        if (javaVersion == null) {
            throw new NullPointerException("javaVersion is marked non-null but is null");
        }
        JavaVersion minJavaVersion = this.minJavaVersion();
        return minJavaVersion == null || !minJavaVersion.supported() || javaVersion.isNewerOrAt(minJavaVersion);
    }
}

