/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.module;

import dev.derklaro.aerogel.SpecifiedInjector;
import eu.cloudnetservice.common.log.LogManager;
import eu.cloudnetservice.common.log.Logger;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.driver.module.DefaultModuleTaskEntry;
import eu.cloudnetservice.driver.module.Module;
import eu.cloudnetservice.driver.module.ModuleConfiguration;
import eu.cloudnetservice.driver.module.ModuleDependency;
import eu.cloudnetservice.driver.module.ModuleLifeCycle;
import eu.cloudnetservice.driver.module.ModuleProvider;
import eu.cloudnetservice.driver.module.ModuleTask;
import eu.cloudnetservice.driver.module.ModuleTaskEntry;
import eu.cloudnetservice.driver.module.ModuleWrapper;
import eu.cloudnetservice.driver.module.util.ModuleDependencyUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.NonNull;
import org.jetbrains.annotations.Unmodifiable;

public class DefaultModuleWrapper
implements ModuleWrapper {
    protected static final Logger LOGGER = LogManager.logger(DefaultModuleWrapper.class);
    protected static final Comparator<ModuleTaskEntry> TASK_COMPARATOR = Comparator.comparing(entry -> entry.taskInfo().order(), Comparator.reverseOrder());
    private final URL source;
    private final URI sourceUri;
    private final Module module;
    private final Path dataDirectory;
    private final ModuleProvider provider;
    private final URLClassLoader classLoader;
    private final Set<ModuleDependency> dependingModules;
    private final ModuleConfiguration moduleConfiguration;
    private final InjectionLayer<SpecifiedInjector> moduleInjectionLayer;
    private final Lock moduleLifecycleUpdateLock = new ReentrantLock();
    private final Map<ModuleLifeCycle, List<ModuleTaskEntry>> tasks = new EnumMap<ModuleLifeCycle, List<ModuleTaskEntry>>(ModuleLifeCycle.class);
    private final AtomicReference<ModuleLifeCycle> lifeCycle = new AtomicReference<ModuleLifeCycle>(ModuleLifeCycle.CREATED);

    public DefaultModuleWrapper(@NonNull URL source, @NonNull Module module, @NonNull Path dataDirectory, @NonNull ModuleProvider provider, @NonNull URLClassLoader classLoader, @NonNull Set<ModuleDependency> dependingModules, @NonNull ModuleConfiguration moduleConfiguration, @NonNull InjectionLayer<SpecifiedInjector> moduleInjectionLayer) throws URISyntaxException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (module == null) {
            throw new NullPointerException("module is marked non-null but is null");
        }
        if (dataDirectory == null) {
            throw new NullPointerException("dataDirectory is marked non-null but is null");
        }
        if (provider == null) {
            throw new NullPointerException("provider is marked non-null but is null");
        }
        if (classLoader == null) {
            throw new NullPointerException("classLoader is marked non-null but is null");
        }
        if (dependingModules == null) {
            throw new NullPointerException("dependingModules is marked non-null but is null");
        }
        if (moduleConfiguration == null) {
            throw new NullPointerException("moduleConfiguration is marked non-null but is null");
        }
        if (moduleInjectionLayer == null) {
            throw new NullPointerException("moduleInjectionLayer is marked non-null but is null");
        }
        this.source = source;
        this.module = module;
        this.dataDirectory = dataDirectory;
        this.provider = provider;
        this.classLoader = classLoader;
        this.dependingModules = dependingModules;
        this.moduleConfiguration = moduleConfiguration;
        this.moduleInjectionLayer = moduleInjectionLayer;
        this.sourceUri = source.toURI();
        this.tasks.putAll(this.resolveModuleTasks(module));
    }

    @Override
    @NonNull
    public Map<ModuleLifeCycle, List<ModuleTaskEntry>> moduleTasks() {
        return Collections.unmodifiableMap(this.tasks);
    }

    @Override
    @NonNull
    public @Unmodifiable Set<ModuleDependency> dependingModules() {
        return Collections.unmodifiableSet(this.dependingModules);
    }

    @Override
    @NonNull
    public Module module() {
        return this.module;
    }

    @Override
    @NonNull
    public ModuleLifeCycle moduleLifeCycle() {
        return this.lifeCycle.get();
    }

    @Override
    @NonNull
    public ModuleProvider moduleProvider() {
        return this.provider;
    }

    @Override
    @NonNull
    public ModuleConfiguration moduleConfiguration() {
        return this.moduleConfiguration;
    }

    @Override
    @NonNull
    public ClassLoader classLoader() {
        return this.classLoader;
    }

    @Override
    @NonNull
    public ModuleWrapper loadModule() {
        this.pushLifecycleChange(ModuleLifeCycle.LOADED, true);
        return this;
    }

    @Override
    @NonNull
    public ModuleWrapper startModule() {
        if (this.moduleLifeCycle().canChangeTo(ModuleLifeCycle.STARTED) && this.provider.notifyPreModuleLifecycleChange(this, ModuleLifeCycle.STARTED)) {
            for (ModuleWrapper wrapper : ModuleDependencyUtil.collectDependencies(this, this.provider)) {
                wrapper.startModule();
            }
            this.pushLifecycleChange(ModuleLifeCycle.STARTED, false);
            this.provider.notifyPostModuleLifecycleChange(this, ModuleLifeCycle.STARTED);
        }
        return this;
    }

    @Override
    @NonNull
    public ModuleWrapper reloadModule() {
        if (this.moduleConfiguration.runtimeModule()) {
            return this;
        }
        if (this.moduleLifeCycle().canChangeTo(ModuleLifeCycle.RELOADING) && this.provider.notifyPreModuleLifecycleChange(this, ModuleLifeCycle.RELOADING)) {
            for (ModuleWrapper wrapper : ModuleDependencyUtil.collectDependencies(this, this.provider)) {
                wrapper.reloadModule();
            }
            this.pushLifecycleChange(ModuleLifeCycle.RELOADING, false);
            this.provider.notifyPostModuleLifecycleChange(this, ModuleLifeCycle.RELOADING);
            this.lifeCycle.set(ModuleLifeCycle.STARTED);
        }
        return this;
    }

    @Override
    @NonNull
    public ModuleWrapper stopModule() {
        this.pushLifecycleChange(ModuleLifeCycle.STOPPED, true);
        return this;
    }

    @Override
    @NonNull
    public ModuleWrapper unloadModule() {
        if (this.moduleLifeCycle().canChangeTo(ModuleLifeCycle.UNLOADED)) {
            this.pushLifecycleChange(ModuleLifeCycle.UNLOADED, true);
            this.tasks.clear();
            this.dependingModules.clear();
            try {
                this.classLoader.close();
            }
            catch (IOException exception) {
                LOGGER.severe(String.format("Exception closing class loader of module %s", this.moduleConfiguration.name()), (Throwable)exception, new Object[0]);
            }
            this.lifeCycle.set(ModuleLifeCycle.UNUSABLE);
        }
        return this;
    }

    @Override
    @NonNull
    public Path dataDirectory() {
        return this.dataDirectory;
    }

    @Override
    @NonNull
    public URL url() {
        return this.source;
    }

    @Override
    @NonNull
    public URI uri() {
        return this.sourceUri;
    }

    @Override
    @NonNull
    public InjectionLayer<SpecifiedInjector> injectionLayer() {
        return this.moduleInjectionLayer;
    }

    @NonNull
    protected Map<ModuleLifeCycle, List<ModuleTaskEntry>> resolveModuleTasks(@NonNull Module module) {
        if (module == null) {
            throw new NullPointerException("module is marked non-null but is null");
        }
        EnumMap<ModuleLifeCycle, List<ModuleTaskEntry>> result = new EnumMap<ModuleLifeCycle, List<ModuleTaskEntry>>(ModuleLifeCycle.class);
        for (Method method : module.getClass().getDeclaredMethods()) {
            ModuleTask moduleTask = method.getAnnotation(ModuleTask.class);
            if (moduleTask == null || Modifier.isStatic(method.getModifiers())) continue;
            try {
                List entries = result.computeIfAbsent(moduleTask.lifecycle(), $ -> new ArrayList());
                entries.add(new DefaultModuleTaskEntry(this, moduleTask, method));
                entries.sort(TASK_COMPARATOR);
            }
            catch (IllegalAccessException exception) {
                LOGGER.severe("Unable to access module task entry to unreflect method", (Throwable)exception, new Object[0]);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pushLifecycleChange(@NonNull ModuleLifeCycle lifeCycle, boolean notifyProvider) {
        block9: {
            if (lifeCycle == null) {
                throw new NullPointerException("lifeCycle is marked non-null but is null");
            }
            List<ModuleTaskEntry> tasks = this.tasks.get((Object)lifeCycle);
            if (this.moduleLifeCycle().canChangeTo(lifeCycle)) {
                this.moduleLifecycleUpdateLock.lock();
                try {
                    if (notifyProvider && !this.moduleProvider().notifyPreModuleLifecycleChange(this, lifeCycle)) break block9;
                    if (tasks != null && !tasks.isEmpty()) {
                        for (ModuleTaskEntry task : tasks) {
                            if (!this.fireModuleTaskEntry(task)) continue;
                            LOGGER.warning(String.format("Stopping lifecycle update to %s for %s because the task %s failed. See console log for more details.", new Object[]{lifeCycle, this.moduleConfiguration.name(), task.fullMethodSignature()}));
                            return;
                        }
                    }
                    this.lifeCycle.set(lifeCycle);
                    if (notifyProvider) {
                        this.moduleProvider().notifyPostModuleLifecycleChange(this, lifeCycle);
                    }
                }
                finally {
                    this.moduleLifecycleUpdateLock.unlock();
                }
            }
        }
    }

    protected boolean fireModuleTaskEntry(@NonNull ModuleTaskEntry entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        try {
            entry.fire();
            return false;
        }
        catch (Throwable exception) {
            LOGGER.severe("Exception firing module task entry %s", exception, new Object[]{entry});
            return true;
        }
    }
}

