/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.inject;

import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.Injector;
import dev.derklaro.aerogel.SpecifiedInjector;
import dev.derklaro.aerogel.auto.runtime.AutoAnnotationRegistry;
import dev.derklaro.aerogel.binding.BindingBuilder;
import dev.derklaro.aerogel.binding.BindingConstructor;
import dev.derklaro.aerogel.util.Qualifiers;
import eu.cloudnetservice.common.StringUtil;
import eu.cloudnetservice.driver.inject.BootLayerConfigurator;
import eu.cloudnetservice.driver.inject.DefaultInjectionLayer;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.driver.inject.InjectionLayerHolder;
import eu.cloudnetservice.driver.inject.InjectionLayerRegistry;
import io.leangen.geantyref.TypeFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ServiceLoader;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import lombok.NonNull;

final class InjectionLayerProvider {
    static final InjectionLayerRegistry REGISTRY = new InjectionLayerRegistry();
    private static final Element RAW_ELEMENT = Element.forType(InjectionLayer.class);
    private static final Element GENERIC_ELEMENT = Element.forType((Type)TypeFactory.parameterizedClass(InjectionLayer.class, (Type[])new Type[]{TypeFactory.unboundWildcard()}));
    private static final Element INJECTOR_ELEMENT = Element.forType((Type)TypeFactory.parameterizedClass(InjectionLayer.class, (Type[])new Type[]{Injector.class}));
    private static final Element SPECIFIED_INJECTOR_ELEMENT = Element.forType((Type)TypeFactory.parameterizedClass(InjectionLayer.class, (Type[])new Type[]{SpecifiedInjector.class}));
    private static InjectionLayer<Injector> boot;
    private static InjectionLayer<Injector> ext;

    private InjectionLayerProvider() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static InjectionLayer<Injector> boot() {
        if (boot != null) {
            return boot;
        }
        boot = InjectionLayerProvider.fresh("boot").asUncloseable();
        ServiceLoader<BootLayerConfigurator> serviceLoader = ServiceLoader.load(BootLayerConfigurator.class);
        for (BootLayerConfigurator configurator : serviceLoader) {
            configurator.configureBootLayer(boot);
        }
        ext = InjectionLayerProvider.child(boot, "ext").asUncloseable();
        return boot;
    }

    @NonNull
    public static InjectionLayer<Injector> ext() {
        if (ext == null) {
            InjectionLayerProvider.boot();
        }
        return ext;
    }

    @NonNull
    public static InjectionLayer<SpecifiedInjector> specifiedChild(@NonNull InjectionLayer<? extends Injector> parent, @NonNull String name, @NonNull BiConsumer<InjectionLayer<SpecifiedInjector>, SpecifiedInjector> configurator) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (configurator == null) {
            throw new NullPointerException("configurator is marked non-null but is null");
        }
        SpecifiedInjector childInjector = parent.injector().newSpecifiedInjector();
        return InjectionLayerProvider.configuredLayer(name, childInjector, ((Consumer<InjectionLayer>)layer -> InjectionLayerProvider.registerBindings(layer, SPECIFIED_INJECTOR_ELEMENT, name, ($, constructor) -> childInjector.installSpecified(constructor))).andThen(layer -> configurator.accept((InjectionLayer<SpecifiedInjector>)layer, childInjector)));
    }

    @NonNull
    public static InjectionLayer<Injector> child(@NonNull InjectionLayer<Injector> parent, @NonNull String name) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Injector childInjector = parent.injector().newChildInjector();
        return InjectionLayerProvider.configuredLayer(name, childInjector, layer -> InjectionLayerProvider.registerBindings(layer, INJECTOR_ELEMENT, name, InjectionLayer::install));
    }

    @NonNull
    public static InjectionLayer<Injector> fresh(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return InjectionLayerProvider.configuredLayer(name, layer -> {
            layer.install(BindingBuilder.create().bind(RAW_ELEMENT).toInstance(layer));
            layer.install(BindingBuilder.create().bind(GENERIC_ELEMENT).toInstance(layer));
            layer.install(BindingBuilder.create().bind(INJECTOR_ELEMENT).toInstance(layer));
        });
    }

    @NonNull
    public static InjectionLayer<Injector> configuredLayer(@NonNull String name, @NonNull Consumer<InjectionLayer<Injector>> configurator) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (configurator == null) {
            throw new NullPointerException("configurator is marked non-null but is null");
        }
        return InjectionLayerProvider.configuredLayer(name, Injector.newInjector(), configurator);
    }

    @NonNull
    private static <I extends Injector> InjectionLayer<I> configuredLayer(@NonNull String name, @NonNull I injector, @NonNull Consumer<InjectionLayer<I>> configurator) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (injector == null) {
            throw new NullPointerException("injector is marked non-null but is null");
        }
        if (configurator == null) {
            throw new NullPointerException("configurator is marked non-null but is null");
        }
        InjectionLayerProvider.validateName(name);
        DefaultInjectionLayer<I> layer = new DefaultInjectionLayer<I>(injector, AutoAnnotationRegistry.newRegistry(), name);
        configurator.accept(layer);
        return layer;
    }

    @NonNull
    public static InjectionLayer<?> findLayerOf(@NonNull Object object, @NonNull InjectionLayer<?> def) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (def == null) {
            throw new NullPointerException("def is marked non-null but is null");
        }
        if (object instanceof InjectionLayerHolder) {
            InjectionLayerHolder layerHolder = (InjectionLayerHolder)object;
            return layerHolder.injectionLayer();
        }
        InjectionLayer<? extends Injector> registeredLayer = REGISTRY.findByHint(object);
        if (registeredLayer != null) {
            return registeredLayer;
        }
        if (object instanceof Class) {
            Class clazz = (Class)object;
            return InjectionLayerProvider.findLayerOf(clazz.getClassLoader(), def);
        }
        if (!(object instanceof ClassLoader)) {
            ClassLoader loader = object.getClass().getClassLoader();
            return InjectionLayerProvider.findLayerOf(loader, def);
        }
        ClassLoader loader = (ClassLoader)object;
        if (loader != ClassLoader.getSystemClassLoader() && loader.getParent() != null) {
            return InjectionLayerProvider.findLayerOf(loader.getParent(), def);
        }
        return def;
    }

    private static void validateName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (boot == null || ext == null) {
            return;
        }
        String normalizedName = StringUtil.toLower((String)name);
        if (normalizedName.equals("boot") || normalizedName.equals("ext")) {
            throw new IllegalArgumentException("The \"boot\" or \"ext\" injection layer name is reserved and cannot be used twice");
        }
        if (normalizedName.isEmpty()) {
            throw new IllegalArgumentException("Injection layer name cannot be empty");
        }
    }

    private static void registerBindings(@NonNull InjectionLayer<?> layer, @NonNull Element mainElement, @NonNull String name, @NonNull BiConsumer<InjectionLayer<?>, BindingConstructor> registerFunction) {
        if (layer == null) {
            throw new NullPointerException("layer is marked non-null but is null");
        }
        if (mainElement == null) {
            throw new NullPointerException("mainElement is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (registerFunction == null) {
            throw new NullPointerException("registerFunction is marked non-null but is null");
        }
        registerFunction.accept(layer, BindingBuilder.create().bind(RAW_ELEMENT.requireAnnotation((Annotation)Qualifiers.named((String)name))).toInstance(layer));
        registerFunction.accept(layer, BindingBuilder.create().bind(GENERIC_ELEMENT.requireAnnotation((Annotation)Qualifiers.named((String)name))).toInstance(layer));
        registerFunction.accept(layer, BindingBuilder.create().bind(mainElement.requireAnnotation((Annotation)Qualifiers.named((String)name))).toInstance(layer));
    }
}

