/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.event.events.channel;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.common.concurrent.Task;
import eu.cloudnetservice.driver.channel.ChannelMessage;
import eu.cloudnetservice.driver.channel.ChannelMessageSender;
import eu.cloudnetservice.driver.channel.ChannelMessageTarget;
import eu.cloudnetservice.driver.event.events.network.NetworkEvent;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public final class ChannelMessageReceiveEvent
extends NetworkEvent {
    private final ChannelMessage channelMessage;
    private final boolean query;
    private volatile CompletableFuture<ChannelMessage> queryResponse;

    public ChannelMessageReceiveEvent(@NonNull ChannelMessage message, @NonNull NetworkChannel networkChannel, boolean query) {
        super(networkChannel);
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (networkChannel == null) {
            throw new NullPointerException("networkChannel is marked non-null but is null");
        }
        this.channelMessage = message;
        this.query = query;
    }

    @NonNull
    public ChannelMessageSender sender() {
        return this.channelMessage.sender();
    }

    @NonNull
    public Collection<ChannelMessageTarget> targets() {
        return this.channelMessage.targets();
    }

    @NonNull
    public String channel() {
        return this.channelMessage.channel();
    }

    @NonNull
    public String message() {
        return this.channelMessage.message();
    }

    @NonNull
    public ChannelMessage channelMessage() {
        return this.channelMessage;
    }

    @NonNull
    public DataBuf content() {
        return this.channelMessage.content();
    }

    public boolean query() {
        return this.query;
    }

    public void binaryResponse(@NonNull DataBuf dataBuf) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        this.queryResponse(ChannelMessage.buildResponseFor(this.channelMessage).buffer(dataBuf).build());
    }

    @Nullable
    public CompletableFuture<ChannelMessage> queryResponse() {
        return this.queryResponse;
    }

    public void queryResponse(@Nullable ChannelMessage queryResponse) {
        Preconditions.checkArgument((boolean)this.query, (Object)"Cannot set query response of no query");
        this.queryResponse((CompletableFuture<ChannelMessage>)(queryResponse == null ? null : Task.completedTask((Object)queryResponse)));
    }

    public void queryResponse(@Nullable CompletableFuture<ChannelMessage> queryResponse) {
        Preconditions.checkArgument((boolean)this.query, (Object)"Cannot set query response of no query");
        this.queryResponse = queryResponse;
    }
}

