/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.database;

import eu.cloudnetservice.common.Nameable;
import eu.cloudnetservice.common.concurrent.Task;
import eu.cloudnetservice.common.document.gson.JsonDocument;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCValidation;
import java.util.Collection;
import java.util.Map;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

@RPCValidation
public interface Database
extends Nameable,
AutoCloseable {
    public boolean insert(@NonNull String var1, @NonNull JsonDocument var2);

    public boolean contains(@NonNull String var1);

    public boolean delete(@NonNull String var1);

    @Nullable
    public JsonDocument get(@NonNull String var1);

    @NonNull
    public Collection<JsonDocument> find(@NonNull String var1, @Nullable String var2);

    @NonNull
    public Collection<JsonDocument> find(@NonNull Map<String, String> var1);

    @NonNull
    public Collection<String> keys();

    @NonNull
    public Collection<JsonDocument> documents();

    @NonNull
    public Map<String, JsonDocument> entries();

    public void clear();

    public long documentCount();

    public boolean synced();

    @NonNull
    default public Task<Boolean> insertAsync(@NonNull String key, @NonNull JsonDocument document) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        return Task.supply(() -> this.insert(key, document));
    }

    @NonNull
    default public Task<Boolean> containsAsync(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Task.supply(() -> this.contains(key));
    }

    @NonNull
    default public Task<Boolean> deleteAsync(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Task.supply(() -> this.delete(key));
    }

    @NonNull
    default public Task<JsonDocument> getAsync(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Task.supply(() -> this.get(key));
    }

    @NonNull
    default public Task<Collection<JsonDocument>> findAsync(@NonNull String fieldName, @Nullable String fieldValue) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        return Task.supply(() -> this.find(fieldName, fieldValue));
    }

    @NonNull
    default public Task<Collection<JsonDocument>> findAsync(@NonNull Map<String, String> filters) {
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        return Task.supply(() -> this.find(filters));
    }

    @NonNull
    default public Task<Collection<String>> keysAsync() {
        return Task.supply(this::keys);
    }

    @NonNull
    default public Task<Collection<JsonDocument>> documentsAsync() {
        return Task.supply(this::documents);
    }

    @NonNull
    default public Task<Map<String, JsonDocument>> entriesAsync() {
        return Task.supply(this::entries);
    }

    @NonNull
    default public Task<Void> clearAsync() {
        return Task.supply(this::clear);
    }

    @NonNull
    default public Task<Long> documentCountAsync() {
        return Task.supply(this::documentCount);
    }
}

