/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.channel;

import eu.cloudnetservice.driver.ComponentInfo;
import eu.cloudnetservice.driver.DriverEnvironment;
import eu.cloudnetservice.driver.channel.ChannelMessageTarget;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.driver.network.cluster.NetworkClusterNode;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import lombok.NonNull;

public record ChannelMessageSender(@NonNull String name, @NonNull DriverEnvironment type) {
    public ChannelMessageSender(@NonNull String name, @NonNull DriverEnvironment type) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
    }

    @NonNull
    public static ChannelMessageSender of(@NonNull String name, @NonNull DriverEnvironment environment) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        return new ChannelMessageSender(name, environment);
    }

    @NonNull
    public static ChannelMessageSender self() {
        ComponentInfo componentInfo = InjectionLayer.boot().instance(ComponentInfo.class);
        return new ChannelMessageSender(componentInfo.componentName(), componentInfo.environment());
    }

    public boolean is(@NonNull ServiceInfoSnapshot serviceInfoSnapshot) {
        if (serviceInfoSnapshot == null) {
            throw new NullPointerException("serviceInfoSnapshot is marked non-null but is null");
        }
        return this.type.equals(DriverEnvironment.WRAPPER) && this.name.equals(serviceInfoSnapshot.name());
    }

    public boolean is(@NonNull NetworkClusterNode node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        return this.type.equals(DriverEnvironment.NODE) && this.name.equals(node.uniqueId());
    }

    @NonNull
    public ChannelMessageTarget toTarget() {
        ChannelMessageTarget.Type type = this.type.equals(DriverEnvironment.NODE) ? ChannelMessageTarget.Type.NODE : ChannelMessageTarget.Type.SERVICE;
        return new ChannelMessageTarget(type, this.name);
    }
}

