/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.channel;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.common.concurrent.Task;
import eu.cloudnetservice.driver.DriverEnvironment;
import eu.cloudnetservice.driver.channel.ChannelMessageSender;
import eu.cloudnetservice.driver.channel.ChannelMessageTarget;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.provider.CloudMessenger;
import eu.cloudnetservice.driver.service.ServiceEnvironmentType;
import java.util.ArrayList;
import java.util.Collection;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public record ChannelMessage(boolean sendSync, boolean prioritized, @NonNull String channel, @NonNull String message, @NonNull DataBuf content, @NonNull ChannelMessageSender sender, @NonNull Collection<ChannelMessageTarget> targets) {
    public ChannelMessage(boolean sendSync, boolean prioritized, @NonNull String channel, @NonNull String message, @NonNull DataBuf content, @NonNull ChannelMessageSender sender, @NonNull Collection<ChannelMessageTarget> targets) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (targets == null) {
            throw new NullPointerException("targets is marked non-null but is null");
        }
    }

    @Contract(value=" -> new")
    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @Contract(value="_ -> new")
    @NonNull
    public static Builder buildResponseFor(@NonNull ChannelMessage input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return ChannelMessage.builder().channel("").message("").target(input.sender.type(), input.sender.name());
    }

    public void send() {
        this.messenger().sendChannelMessage(this);
    }

    @NonNull
    public Task<Collection<ChannelMessage>> sendQueryAsync() {
        return this.messenger().sendChannelMessageQueryAsync(this);
    }

    @NonNull
    public Task<ChannelMessage> sendSingleQueryAsync() {
        return this.messenger().sendSingleChannelMessageQueryAsync(this);
    }

    @NonNull
    public Collection<ChannelMessage> sendQuery() {
        return this.messenger().sendChannelMessageQuery(this);
    }

    @Nullable
    public ChannelMessage sendSingleQuery() {
        return this.messenger().sendSingleChannelMessageQuery(this);
    }

    @NonNull
    private CloudMessenger messenger() {
        return InjectionLayer.boot().instance(CloudMessenger.class);
    }

    public static final class Builder {
        private final Collection<ChannelMessageTarget> targets = new ArrayList<ChannelMessageTarget>();
        private String channel;
        private String message;
        private boolean sendSync;
        private boolean prioritized;
        private DataBuf content;
        private ChannelMessageSender sender;

        @NonNull
        public Builder sender(@NonNull ChannelMessageSender sender) {
            if (sender == null) {
                throw new NullPointerException("sender is marked non-null but is null");
            }
            this.sender = sender;
            return this;
        }

        @NonNull
        public Builder channel(@NonNull String channel) {
            if (channel == null) {
                throw new NullPointerException("channel is marked non-null but is null");
            }
            this.channel = channel;
            return this;
        }

        @NonNull
        public Builder message(@NonNull String message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
            return this;
        }

        @NonNull
        public Builder sendSync(boolean sync) {
            this.sendSync = sync;
            return this;
        }

        @ApiStatus.Experimental
        @NonNull
        public Builder prioritized(boolean prioritized) {
            this.prioritized = prioritized;
            return this;
        }

        @NonNull
        public Builder buffer(@Nullable DataBuf dataBuf) {
            this.content = dataBuf;
            return this;
        }

        @NonNull
        public Builder target(@NonNull ChannelMessageTarget target) {
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            this.targets.add(target);
            return this;
        }

        @NonNull
        public Builder target(@NonNull ChannelMessageTarget.Type type, @Nullable String name) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            return this.target(ChannelMessageTarget.of(type, name));
        }

        @NonNull
        public Builder target(@NonNull DriverEnvironment environment, @Nullable String name) {
            if (environment == null) {
                throw new NullPointerException("environment is marked non-null but is null");
            }
            return this.target(environment == DriverEnvironment.NODE ? ChannelMessageTarget.Type.NODE : ChannelMessageTarget.Type.SERVICE, name);
        }

        @NonNull
        public Builder targetAll(@NonNull ChannelMessageTarget.Type type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            return this.target(type, null);
        }

        @NonNull
        public Builder targetAll() {
            return this.target(ChannelMessageTarget.Type.ALL, null);
        }

        @NonNull
        public Builder targetServices() {
            return this.targetAll(ChannelMessageTarget.Type.SERVICE);
        }

        @NonNull
        public Builder targetService(@Nullable String name) {
            return this.target(ChannelMessageTarget.Type.SERVICE, name);
        }

        @NonNull
        public Builder targetTask(@Nullable String name) {
            return this.target(ChannelMessageTarget.Type.TASK, name);
        }

        @NonNull
        public Builder targetNode(@Nullable String name) {
            return this.target(ChannelMessageTarget.Type.NODE, name);
        }

        @NonNull
        public Builder targetNodes() {
            return this.targetAll(ChannelMessageTarget.Type.NODE);
        }

        @NonNull
        public Builder targetEnvironment(@NonNull ServiceEnvironmentType environment) {
            if (environment == null) {
                throw new NullPointerException("environment is marked non-null but is null");
            }
            return this.target(ChannelMessageTarget.environment(environment));
        }

        @Contract(value=" -> new")
        @NonNull
        public ChannelMessage build() {
            Preconditions.checkNotNull((Object)this.channel, (Object)"No channel provided");
            Preconditions.checkNotNull((Object)this.message, (Object)"No message provided");
            Preconditions.checkArgument((!this.targets.isEmpty() ? 1 : 0) != 0, (Object)"No targets provided");
            return new ChannelMessage(this.sendSync, this.prioritized, this.channel, this.message, this.content == null ? DataBuf.empty() : this.content, this.sender == null ? ChannelMessageSender.self() : this.sender, this.targets);
        }
    }
}

