/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class VarHandleUtil {
    private VarHandleUtil() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static VarHandle lookup(@NonNull MethodHandles.Lookup lookup, @NonNull Class<?> declaringClass, @NonNull String name, @NonNull Class<?> fieldType) {
        if (lookup == null) {
            throw new NullPointerException("lookup is marked non-null but is null");
        }
        if (declaringClass == null) {
            throw new NullPointerException("declaringClass is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (fieldType == null) {
            throw new NullPointerException("fieldType is marked non-null but is null");
        }
        try {
            return lookup.findVarHandle(declaringClass, name, fieldType);
        }
        catch (IllegalAccessException | NoSuchFieldException exception) {
            throw new IllegalStateException(String.format("Unable to get VarHandle for field %s in %s", name, declaringClass.getName()));
        }
    }
}

