/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.util;

import eu.cloudnetservice.common.io.FileUtil;
import eu.cloudnetservice.common.language.I18n;
import eu.cloudnetservice.common.resource.ResourceResolver;
import eu.cloudnetservice.common.util.StringUtil;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.NetworkClient;
import eu.cloudnetservice.driver.network.rpc.defaults.object.DefaultObjectMapper;
import eu.cloudnetservice.driver.network.rpc.handler.RPCHandlerRegistry;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.service.ServiceEnvironmentType;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class ModuleHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModuleHelper.class);
    private final EventManager eventManager;
    private final NetworkClient networkClient;
    private final ServiceRegistry serviceRegistry;
    private final RPCHandlerRegistry rpcHandlerRegistry;

    @Inject
    public ModuleHelper(@NonNull EventManager eventManager, @NonNull NetworkClient networkClient, @NonNull ServiceRegistry serviceRegistry, @NonNull RPCHandlerRegistry rpcHandlerRegistry) {
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        if (serviceRegistry == null) {
            throw new NullPointerException("serviceRegistry is marked non-null but is null");
        }
        if (rpcHandlerRegistry == null) {
            throw new NullPointerException("rpcHandlerRegistry is marked non-null but is null");
        }
        this.eventManager = eventManager;
        this.networkClient = networkClient;
        this.serviceRegistry = serviceRegistry;
        this.rpcHandlerRegistry = rpcHandlerRegistry;
    }

    public boolean copyJarContainingClass(@NonNull Class<?> clazz, @NonNull Path target) {
        boolean bl;
        block10: {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            if (target == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            URI uri = ResourceResolver.resolveCodeSourceOfClass(clazz);
            OutputStream out = Files.newOutputStream(target, new OpenOption[0]);
            try {
                FileUtil.copy((InputStream)uri.toURL().openStream(), (OutputStream)out);
                bl = true;
                if (out == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    LOGGER.error("Unable to copy class path entry of {} to {}", new Object[]{clazz, target, exception});
                    return false;
                }
            }
            out.close();
        }
        return bl;
    }

    public void copyPluginConfigurationFileForEnvironment(@NonNull Class<?> clazz, @NonNull ServiceEnvironmentType type, @NonNull Path file) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        FileUtil.openZipFile((Path)file, fileSystem -> {
            InputStream in;
            Path pluginPath = fileSystem.getPath("plugin.yml", new String[0]);
            if (Files.exists(pluginPath, new LinkOption[0])) {
                Files.delete(pluginPath);
            }
            if ((in = clazz.getClassLoader().getResourceAsStream(String.format("plugin.%s.yml", StringUtil.toLower((String)type.name())))) != null) {
                Files.copy(in, pluginPath, new CopyOption[0]);
                in.close();
            }
        });
    }

    public void unregisterAll(@NonNull ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader is marked non-null but is null");
        }
        this.eventManager.unregisterListeners(classLoader);
        this.serviceRegistry.unregisterAll(classLoader);
        DefaultObjectMapper.DEFAULT_MAPPER.unregisterBindings(classLoader);
        this.rpcHandlerRegistry.unregisterHandlers(classLoader);
        I18n.unregisterLanguageFiles((ClassLoader)classLoader);
        this.networkClient.packetRegistry().removeListeners(classLoader);
        for (NetworkChannel channel : this.networkClient.channels()) {
            channel.packetRegistry().removeListeners(classLoader);
        }
    }
}

