/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.template;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public record FileInfo(@NonNull String path, @NonNull String name, boolean directory, boolean hidden, long creationTime, long lastModified, long lastAccess, long size) {
    @Generated
    public FileInfo(@NonNull String path, @NonNull String name, boolean directory, boolean hidden, long creationTime, long lastModified, long lastAccess, long size) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
    }

    @NonNull
    public static FileInfo of(@NonNull Path path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return FileInfo.of(path, (Path)null);
    }

    @NonNull
    public static FileInfo of(@NonNull Path path, @NonNull BasicFileAttributes attributes) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        return FileInfo.of(path, null, attributes);
    }

    @NonNull
    public static FileInfo of(@NonNull Path path, @Nullable Path relativePath) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return FileInfo.of(path, relativePath, Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]));
    }

    @NonNull
    public static FileInfo of(@NonNull Path fullPath, @Nullable Path relativePath, @NonNull BasicFileAttributes attributes) throws IOException {
        if (fullPath == null) {
            throw new NullPointerException("fullPath is marked non-null but is null");
        }
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        if (relativePath == null) {
            relativePath = fullPath;
        }
        return new FileInfo(relativePath.toString().replace(File.separatorChar, '/'), relativePath.getFileName().toString(), attributes.isDirectory(), Files.isHidden(fullPath), attributes.creationTime().toMillis(), attributes.lastModifiedTime().toMillis(), attributes.lastAccessTime().toMillis(), attributes.size());
    }
}

