/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.service;

import eu.cloudnetservice.common.Named;
import java.lang.management.ThreadInfo;
import lombok.Generated;
import lombok.NonNull;

public record ThreadSnapshot(long id, int priority, boolean daemon, @NonNull String name, @NonNull Thread.State threadState) implements Named,
Cloneable
{
    @Generated
    public ThreadSnapshot(long id, int priority, boolean daemon, @NonNull String name, @NonNull Thread.State threadState) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (threadState == null) {
            throw new NullPointerException("threadState is marked non-null but is null");
        }
    }

    @NonNull
    public static ThreadSnapshot from(@NonNull Thread thread) {
        if (thread == null) {
            throw new NullPointerException("thread is marked non-null but is null");
        }
        return new ThreadSnapshot(thread.getId(), thread.getPriority(), thread.isDaemon(), thread.getName(), thread.getState());
    }

    @NonNull
    public static ThreadSnapshot from(@NonNull ThreadInfo info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        return new ThreadSnapshot(info.getThreadId(), info.getPriority(), info.isDaemon(), info.getThreadName(), info.getThreadState());
    }

    @NonNull
    public ThreadSnapshot clone() {
        try {
            return (ThreadSnapshot)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new IllegalStateException();
        }
    }
}

