/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.service;

import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.property.DefaultedDocPropertyHolder;
import eu.cloudnetservice.driver.service.ServiceDeployment;
import eu.cloudnetservice.driver.service.ServiceRemoteInclusion;
import eu.cloudnetservice.driver.service.ServiceTemplate;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Unmodifiable;

public abstract class ServiceConfigurationBase
implements DefaultedDocPropertyHolder {
    protected final Set<ServiceTemplate> templates;
    protected final Set<ServiceDeployment> deployments;
    protected final Set<ServiceRemoteInclusion> includes;
    protected final Document properties;

    protected ServiceConfigurationBase(@NonNull Set<ServiceTemplate> templates, @NonNull Set<ServiceDeployment> deployments, @NonNull Set<ServiceRemoteInclusion> includes, @NonNull Document properties) {
        if (templates == null) {
            throw new NullPointerException("templates is marked non-null but is null");
        }
        if (deployments == null) {
            throw new NullPointerException("deployments is marked non-null but is null");
        }
        if (includes == null) {
            throw new NullPointerException("includes is marked non-null but is null");
        }
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.templates = templates;
        this.deployments = deployments;
        this.includes = includes;
        this.properties = properties;
    }

    public abstract @Unmodifiable @NonNull Collection<String> jvmOptions();

    public abstract @Unmodifiable @NonNull Collection<String> processParameters();

    public abstract @Unmodifiable @NonNull Map<String, String> environmentVariables();

    public @Unmodifiable @NonNull Collection<ServiceRemoteInclusion> inclusions() {
        return this.includes;
    }

    public @Unmodifiable @NonNull Collection<ServiceTemplate> templates() {
        return this.templates;
    }

    public @Unmodifiable @NonNull Collection<ServiceDeployment> deployments() {
        return this.deployments;
    }

    @Override
    @NonNull
    public Document propertyHolder() {
        return this.properties;
    }

    @Generated
    public String toString() {
        return "ServiceConfigurationBase(templates=" + String.valueOf(this.templates) + ", deployments=" + String.valueOf(this.deployments) + ", includes=" + String.valueOf(this.includes) + ", properties=" + String.valueOf(this.properties) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceConfigurationBase)) {
            return false;
        }
        ServiceConfigurationBase other = (ServiceConfigurationBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<ServiceTemplate> this$templates = this.templates;
        Set<ServiceTemplate> other$templates = other.templates;
        if (this$templates == null ? other$templates != null : !((Object)this$templates).equals(other$templates)) {
            return false;
        }
        Set<ServiceDeployment> this$deployments = this.deployments;
        Set<ServiceDeployment> other$deployments = other.deployments;
        if (this$deployments == null ? other$deployments != null : !((Object)this$deployments).equals(other$deployments)) {
            return false;
        }
        Set<ServiceRemoteInclusion> this$includes = this.includes;
        Set<ServiceRemoteInclusion> other$includes = other.includes;
        if (this$includes == null ? other$includes != null : !((Object)this$includes).equals(other$includes)) {
            return false;
        }
        Document this$properties = this.properties;
        Document other$properties = other.properties;
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServiceConfigurationBase;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<ServiceTemplate> $templates = this.templates;
        result = result * 59 + ($templates == null ? 43 : ((Object)$templates).hashCode());
        Set<ServiceDeployment> $deployments = this.deployments;
        result = result * 59 + ($deployments == null ? 43 : ((Object)$deployments).hashCode());
        Set<ServiceRemoteInclusion> $includes = this.includes;
        result = result * 59 + ($includes == null ? 43 : ((Object)$includes).hashCode());
        Document $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        return result;
    }

    public static abstract class Builder<T extends ServiceConfigurationBase, B extends Builder<T, B>>
    implements DefaultedDocPropertyHolder.Mutable.WithDirectModifier<B> {
        protected Set<String> jvmOptions = new LinkedHashSet<String>();
        protected Set<String> processParameters = new LinkedHashSet<String>();
        protected Set<ServiceTemplate> templates = new HashSet<ServiceTemplate>();
        protected Set<ServiceDeployment> deployments = new HashSet<ServiceDeployment>();
        protected Set<ServiceRemoteInclusion> includes = new HashSet<ServiceRemoteInclusion>();
        protected Map<String, String> environmentVariables = new HashMap<String, String>();
        protected Document.Mutable properties = Document.newJsonDocument();

        @NonNull
        public B properties(@NonNull Document properties) {
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            this.properties = properties.mutableCopy();
            return this.self();
        }

        @NonNull
        public B jvmOptions(@NonNull Collection<String> jvmOptions) {
            if (jvmOptions == null) {
                throw new NullPointerException("jvmOptions is marked non-null but is null");
            }
            this.jvmOptions = new LinkedHashSet<String>(jvmOptions);
            return this.self();
        }

        @NonNull
        public B modifyJvmOptions(@NonNull Consumer<Collection<String>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            modifier.accept(this.jvmOptions);
            return this.self();
        }

        @NonNull
        public B processParameters(@NonNull Collection<String> processParameters) {
            if (processParameters == null) {
                throw new NullPointerException("processParameters is marked non-null but is null");
            }
            this.processParameters = new LinkedHashSet<String>(processParameters);
            return this.self();
        }

        @NonNull
        public B modifyProcessParameters(@NonNull Consumer<Collection<String>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            modifier.accept(this.processParameters);
            return this.self();
        }

        @NonNull
        public B templates(@NonNull Collection<ServiceTemplate> templates) {
            if (templates == null) {
                throw new NullPointerException("templates is marked non-null but is null");
            }
            this.templates = new HashSet<ServiceTemplate>(templates);
            return this.self();
        }

        @NonNull
        public B modifyTemplates(@NonNull Consumer<Collection<ServiceTemplate>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            modifier.accept(this.templates);
            return this.self();
        }

        @NonNull
        public B deployments(@NonNull Collection<ServiceDeployment> deployments) {
            if (deployments == null) {
                throw new NullPointerException("deployments is marked non-null but is null");
            }
            this.deployments = new HashSet<ServiceDeployment>(deployments);
            return this.self();
        }

        @NonNull
        public B modifyDeployments(@NonNull Consumer<Collection<ServiceDeployment>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            modifier.accept(this.deployments);
            return this.self();
        }

        @NonNull
        public B inclusions(@NonNull Collection<ServiceRemoteInclusion> inclusions) {
            if (inclusions == null) {
                throw new NullPointerException("inclusions is marked non-null but is null");
            }
            this.includes = new HashSet<ServiceRemoteInclusion>(inclusions);
            return this.self();
        }

        @NonNull
        public B modifyInclusions(@NonNull Consumer<Collection<ServiceRemoteInclusion>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            modifier.accept(this.includes);
            return this.self();
        }

        @NonNull
        public B environmentVariables(@NonNull Map<String, String> environmentVariables) {
            if (environmentVariables == null) {
                throw new NullPointerException("environmentVariables is marked non-null but is null");
            }
            this.environmentVariables = new HashMap<String, String>(environmentVariables);
            return this.self();
        }

        @NonNull
        public B modifyEnvironmentVariables(@NonNull Consumer<Map<String, String>> modifier) {
            if (modifier == null) {
                throw new NullPointerException("modifier is marked non-null but is null");
            }
            modifier.accept(this.environmentVariables);
            return this.self();
        }

        @Override
        public @NonNull Document.Mutable propertyHolder() {
            return this.properties;
        }

        @NonNull
        protected abstract B self();

        @NonNull
        public abstract T build();
    }
}

