/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.provider;

import eu.cloudnetservice.common.concurrent.TaskUtil;
import eu.cloudnetservice.driver.channel.ChannelMessageSender;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.service.ServiceDeployment;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import eu.cloudnetservice.driver.service.ServiceLifeCycle;
import eu.cloudnetservice.driver.service.ServiceRemoteInclusion;
import eu.cloudnetservice.driver.service.ServiceTemplate;
import io.vavr.CheckedFunction0;
import java.io.Serializable;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public interface SpecificCloudServiceProvider {
    @Nullable
    public ServiceInfoSnapshot serviceInfo();

    public boolean valid();

    @Nullable
    public ServiceInfoSnapshot forceUpdateServiceInfo();

    public void addServiceTemplate(@NonNull ServiceTemplate var1);

    public void addServiceRemoteInclusion(@NonNull ServiceRemoteInclusion var1);

    public void addServiceDeployment(@NonNull ServiceDeployment var1);

    @NonNull
    public Queue<String> cachedLogMessages();

    public boolean toggleScreenEvents(@NonNull ChannelMessageSender var1, @NonNull String var2);

    default public void stop() {
        this.updateLifecycle(ServiceLifeCycle.STOPPED);
    }

    default public void start() {
        this.updateLifecycle(ServiceLifeCycle.RUNNING);
    }

    default public void delete() {
        this.updateLifecycle(ServiceLifeCycle.DELETED);
    }

    public void restart();

    public void updateLifecycle(@NonNull ServiceLifeCycle var1);

    public void deleteFiles();

    public void runCommand(@NonNull String var1);

    @NonNull
    public Collection<ServiceTemplate> installedTemplates();

    @NonNull
    public Collection<ServiceRemoteInclusion> installedInclusions();

    @NonNull
    public Collection<ServiceDeployment> installedDeployments();

    public void includeWaitingServiceTemplates();

    public void includeWaitingServiceTemplates(boolean var1);

    public void includeWaitingServiceInclusions();

    public void deployResources(boolean var1);

    default public void removeAndExecuteDeployments() {
        this.deployResources(true);
    }

    public void updateProperties(@NonNull Document var1);

    @NonNull
    default public CompletableFuture<ServiceInfoSnapshot> serviceInfoAsync() {
        return TaskUtil.supplyAsync(this::serviceInfo);
    }

    @NonNull
    default public CompletableFuture<Boolean> validAsync() {
        return TaskUtil.supplyAsync(this::valid);
    }

    @NonNull
    default public CompletableFuture<ServiceInfoSnapshot> forceUpdateServiceInfoAsync() {
        return TaskUtil.supplyAsync(this::forceUpdateServiceInfo);
    }

    @NonNull
    default public CompletableFuture<Void> addServiceTemplateAsync(@NonNull ServiceTemplate serviceTemplate) {
        if (serviceTemplate == null) {
            throw new NullPointerException("serviceTemplate is marked non-null but is null");
        }
        return TaskUtil.runAsync(() -> this.addServiceTemplate(serviceTemplate));
    }

    @NonNull
    default public CompletableFuture<Void> addServiceRemoteInclusionAsync(@NonNull ServiceRemoteInclusion serviceRemoteInclusion) {
        if (serviceRemoteInclusion == null) {
            throw new NullPointerException("serviceRemoteInclusion is marked non-null but is null");
        }
        return TaskUtil.runAsync(() -> this.addServiceRemoteInclusion(serviceRemoteInclusion));
    }

    @NonNull
    default public CompletableFuture<Void> addServiceDeploymentAsync(@NonNull ServiceDeployment serviceDeployment) {
        if (serviceDeployment == null) {
            throw new NullPointerException("serviceDeployment is marked non-null but is null");
        }
        return TaskUtil.runAsync(() -> this.addServiceDeployment(serviceDeployment));
    }

    @NonNull
    default public CompletableFuture<Queue<String>> cachedLogMessagesAsync() {
        return TaskUtil.supplyAsync(this::cachedLogMessages);
    }

    @NonNull
    default public CompletableFuture<Boolean> toggleScreenEventsAsync(@NonNull ChannelMessageSender sender, @NonNull String channel) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> this.toggleScreenEvents(sender, channel));
    }

    @NonNull
    default public CompletableFuture<Void> stopAsync() {
        return this.updateLifecycleAsync(ServiceLifeCycle.STOPPED);
    }

    @NonNull
    default public CompletableFuture<Void> startAsync() {
        return this.updateLifecycleAsync(ServiceLifeCycle.RUNNING);
    }

    @NonNull
    default public CompletableFuture<Void> deleteAsync() {
        return this.updateLifecycleAsync(ServiceLifeCycle.DELETED);
    }

    @NonNull
    default public CompletableFuture<Void> restartAsync() {
        return TaskUtil.runAsync(this::restart);
    }

    @NonNull
    default public CompletableFuture<Void> updateLifecycleAsync(@NonNull ServiceLifeCycle lifeCycle) {
        if (lifeCycle == null) {
            throw new NullPointerException("lifeCycle is marked non-null but is null");
        }
        return TaskUtil.runAsync(() -> this.updateLifecycle(lifeCycle));
    }

    @NonNull
    default public CompletableFuture<Void> deleteFilesAsync() {
        return TaskUtil.runAsync(this::deleteFiles);
    }

    @NonNull
    default public CompletableFuture<Void> runCommandAsync(@NonNull String command) {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        return TaskUtil.runAsync(() -> this.runCommand(command));
    }

    @NonNull
    default public CompletableFuture<Void> includeWaitingServiceTemplatesAsync() {
        return TaskUtil.runAsync(() -> this.includeWaitingServiceTemplates());
    }

    @NonNull
    default public CompletableFuture<Void> includeWaitingServiceTemplatesAsync(boolean force) {
        return TaskUtil.runAsync(() -> this.includeWaitingServiceTemplates(force));
    }

    @NonNull
    default public CompletableFuture<Void> includeWaitingServiceInclusionsAsync() {
        return TaskUtil.runAsync(this::includeWaitingServiceInclusions);
    }

    @NonNull
    default public CompletableFuture<Void> deployResourcesAsync(boolean removeDeployments) {
        return TaskUtil.runAsync(() -> this.deployResources(removeDeployments));
    }

    @NonNull
    default public CompletableFuture<Void> executeAndRemoveDeploymentsAsync() {
        return this.deployResourcesAsync(true);
    }

    @NonNull
    default public CompletableFuture<Void> updatePropertiesAsync(@NonNull Document properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        return TaskUtil.runAsync(() -> this.updateProperties(properties));
    }
}

