/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.provider;

import eu.cloudnetservice.common.concurrent.TaskUtil;
import eu.cloudnetservice.driver.service.ServiceTask;
import io.vavr.CheckedFunction0;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public interface ServiceTaskProvider {
    public void reload();

    public @UnmodifiableView @NonNull Collection<ServiceTask> serviceTasks();

    @Nullable
    public ServiceTask serviceTask(@NonNull String var1);

    public boolean addServiceTask(@NonNull ServiceTask var1);

    public void removeServiceTaskByName(@NonNull String var1);

    public void removeServiceTask(@NonNull ServiceTask var1);

    @NonNull
    default public CompletableFuture<Void> reloadAsync() {
        return TaskUtil.runAsync(this::reload);
    }

    @NonNull
    default public CompletableFuture<Collection<ServiceTask>> serviceTasksAsync() {
        return TaskUtil.supplyAsync(this::serviceTasks);
    }

    @NonNull
    default public CompletableFuture<ServiceTask> serviceTaskAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> this.serviceTask(name));
    }

    @NonNull
    default public CompletableFuture<Boolean> addServiceTaskAsync(@NonNull ServiceTask serviceTask) {
        if (serviceTask == null) {
            throw new NullPointerException("serviceTask is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> this.addServiceTask(serviceTask));
    }

    @NonNull
    default public CompletableFuture<Void> removeServiceTaskByNameAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return TaskUtil.runAsync(() -> this.removeServiceTaskByName(name));
    }

    @NonNull
    default public CompletableFuture<Void> removeServiceTaskAsync(@NonNull ServiceTask serviceTask) {
        if (serviceTask == null) {
            throw new NullPointerException("serviceTask is marked non-null but is null");
        }
        return TaskUtil.runAsync(() -> this.removeServiceTask(serviceTask));
    }
}

