/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.provider;

import eu.cloudnetservice.common.concurrent.TaskUtil;
import eu.cloudnetservice.driver.cluster.NetworkClusterNode;
import eu.cloudnetservice.driver.cluster.NodeInfoSnapshot;
import eu.cloudnetservice.driver.command.CommandInfo;
import io.vavr.CheckedFunction0;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public interface ClusterNodeProvider {
    public @UnmodifiableView @NonNull Collection<CommandInfo> consoleCommands();

    @Nullable
    public CommandInfo consoleCommand(@NonNull String var1);

    @NonNull
    public Collection<String> consoleTabCompleteResults(@NonNull String var1);

    @NonNull
    public Collection<String> sendCommandLine(@NonNull String var1);

    public @UnmodifiableView @NonNull Collection<NetworkClusterNode> nodes();

    @Nullable
    public NetworkClusterNode node(@NonNull String var1);

    public boolean addNode(@NonNull NetworkClusterNode var1);

    public boolean removeNode(@NonNull String var1);

    @NonNull
    public Collection<NodeInfoSnapshot> nodeInfoSnapshots();

    @Nullable
    public NodeInfoSnapshot nodeInfoSnapshot(@NonNull String var1);

    @NonNull
    default public CompletableFuture<Collection<CommandInfo>> consoleCommandsAsync() {
        return TaskUtil.supplyAsync(this::consoleCommands);
    }

    @NonNull
    default public CompletableFuture<CommandInfo> consoleCommandAsync(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> this.consoleCommand(name));
    }

    @NonNull
    default public CompletableFuture<Collection<String>> consoleTabCompleteResultsAsync(@NonNull String commandLine) {
        if (commandLine == null) {
            throw new NullPointerException("commandLine is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> this.consoleTabCompleteResults(commandLine));
    }

    @NonNull
    default public CompletableFuture<Collection<String>> sendCommandLineAsync(@NonNull String commandLine) {
        if (commandLine == null) {
            throw new NullPointerException("commandLine is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> this.sendCommandLine(commandLine));
    }

    @NonNull
    default public CompletableFuture<Collection<NetworkClusterNode>> nodesAsync() {
        return TaskUtil.supplyAsync(this::nodes);
    }

    @NonNull
    default public CompletableFuture<NetworkClusterNode> nodeAsync(@NonNull String uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> this.node(uniqueId));
    }

    @NonNull
    default public CompletableFuture<Boolean> addNodeAsync(@NonNull NetworkClusterNode node) {
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> this.addNode(node));
    }

    @NonNull
    default public CompletableFuture<Boolean> removeNodeAsync(@NonNull String uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> this.removeNode(uniqueId));
    }

    @NonNull
    default public CompletableFuture<Collection<NodeInfoSnapshot>> nodeInfoSnapshotsAsync() {
        return TaskUtil.supplyAsync(this::nodeInfoSnapshots);
    }

    @NonNull
    default public CompletableFuture<NodeInfoSnapshot> nodeInfoSnapshotAsync(@NonNull String uniqueId) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> this.nodeInfoSnapshot(uniqueId));
    }
}

