/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.provider;

import eu.cloudnetservice.common.concurrent.TaskUtil;
import eu.cloudnetservice.driver.channel.ChannelMessage;
import io.vavr.CheckedFunction0;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public interface CloudMessenger {
    public void sendChannelMessage(@NonNull ChannelMessage var1);

    @NonNull
    public Collection<ChannelMessage> sendChannelMessageQuery(@NonNull ChannelMessage var1);

    @Nullable
    public ChannelMessage sendSingleChannelMessageQuery(@NonNull ChannelMessage var1);

    @NonNull
    default public CompletableFuture<Void> sendChannelMessageAsync(@NonNull ChannelMessage channelMessage) {
        if (channelMessage == null) {
            throw new NullPointerException("channelMessage is marked non-null but is null");
        }
        return TaskUtil.runAsync(() -> this.sendChannelMessage(channelMessage));
    }

    @NonNull
    default public CompletableFuture<Collection<ChannelMessage>> sendChannelMessageQueryAsync(@NonNull ChannelMessage message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> this.sendChannelMessageQuery(message));
    }

    @NonNull
    default public CompletableFuture<ChannelMessage> sendSingleChannelMessageQueryAsync(@NonNull ChannelMessage channelMessage) {
        if (channelMessage == null) {
            throw new NullPointerException("channelMessage is marked non-null but is null");
        }
        return TaskUtil.supplyAsync((CheckedFunction0 & Serializable)() -> this.sendSingleChannelMessageQuery(channelMessage));
    }
}

