/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.scheduler;

import com.google.common.base.Preconditions;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import lombok.NonNull;

final class TimedSynchronousQueue<E>
extends SynchronousQueue<E> {
    private final LongSupplier timeoutSupplier;
    private ThreadPoolExecutor parentExecutor;

    public TimedSynchronousQueue(@NonNull LongSupplier timeoutSupplier) {
        super(true);
        if (timeoutSupplier == null) {
            throw new NullPointerException("timeoutSupplier is marked non-null but is null");
        }
        this.timeoutSupplier = timeoutSupplier;
    }

    public void parentExecutor(@NonNull ThreadPoolExecutor parentExecutor) {
        if (parentExecutor == null) {
            throw new NullPointerException("parentExecutor is marked non-null but is null");
        }
        Preconditions.checkState((this.parentExecutor == null ? 1 : 0) != 0, (Object)"parent executor already set");
        this.parentExecutor = parentExecutor;
    }

    @Override
    public boolean offer(@NonNull E element) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        ThreadPoolExecutor executor = this.parentExecutor;
        if (executor != null) {
            boolean polledByExecutor;
            if (executor.isShutdown()) {
                return false;
            }
            if (executor.getActiveCount() < executor.getPoolSize() && (polledByExecutor = this.offerSafe(element, 50L))) {
                return true;
            }
            if (executor.getPoolSize() < executor.getMaximumPoolSize()) {
                return false;
            }
        }
        long offerTimeout = this.timeoutSupplier.getAsLong();
        return this.offerSafe(element, offerTimeout);
    }

    private boolean offerSafe(@NonNull E element, long timeoutMillis) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        try {
            return super.offer(element, timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
    }
}

