/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.sender;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.NetworkComponent;
import eu.cloudnetservice.driver.network.buffer.DataBufFactory;
import eu.cloudnetservice.driver.network.rpc.RPCSender;
import eu.cloudnetservice.driver.network.rpc.defaults.sender.DefaultRPCSender;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.network.rpc.introspec.RPCClassMetadata;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import java.lang.invoke.TypeDescriptor;
import java.util.function.Supplier;
import lombok.NonNull;

public final class DefaultRPCSenderBuilder
implements RPCSender.Builder {
    private final RPCFactory sourceFactory;
    private final RPCClassMetadata classMetadata;
    private ObjectMapper objectMapper;
    private DataBufFactory dataBufFactory;
    private Supplier<NetworkChannel> channelSupplier;

    public DefaultRPCSenderBuilder(@NonNull RPCFactory sourceFactory, @NonNull RPCClassMetadata classMetadata, @NonNull DataBufFactory dataBufFactory, @NonNull ObjectMapper objectMapper) {
        if (sourceFactory == null) {
            throw new NullPointerException("sourceFactory is marked non-null but is null");
        }
        if (classMetadata == null) {
            throw new NullPointerException("classMetadata is marked non-null but is null");
        }
        if (dataBufFactory == null) {
            throw new NullPointerException("dataBufFactory is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        this.sourceFactory = sourceFactory;
        this.classMetadata = classMetadata;
        this.dataBufFactory = dataBufFactory;
        this.objectMapper = objectMapper;
    }

    @Override
    @NonNull
    public RPCSender.Builder targetComponent(@NonNull NetworkComponent networkComponent) {
        if (networkComponent == null) {
            throw new NullPointerException("networkComponent is marked non-null but is null");
        }
        return this.targetChannel(networkComponent::firstChannel);
    }

    @Override
    @NonNull
    public RPCSender.Builder targetChannel(@NonNull NetworkChannel channel) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        return this.targetChannel(() -> channel);
    }

    @Override
    @NonNull
    public RPCSender.Builder targetChannel(@NonNull Supplier<NetworkChannel> channelSupplier) {
        if (channelSupplier == null) {
            throw new NullPointerException("channelSupplier is marked non-null but is null");
        }
        this.channelSupplier = channelSupplier;
        return this;
    }

    @Override
    @NonNull
    public RPCSender.Builder excludeMethod(@NonNull String name, @NonNull TypeDescriptor methodDescriptor) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (methodDescriptor == null) {
            throw new NullPointerException("methodDescriptor is marked non-null but is null");
        }
        this.classMetadata.unregisterMethod(name, methodDescriptor);
        return this;
    }

    @Override
    @NonNull
    public RPCSender.Builder objectMapper(@NonNull ObjectMapper objectMapper) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        this.objectMapper = objectMapper;
        return this;
    }

    @Override
    @NonNull
    public RPCSender.Builder dataBufFactory(@NonNull DataBufFactory dataBufFactory) {
        if (dataBufFactory == null) {
            throw new NullPointerException("dataBufFactory is marked non-null but is null");
        }
        this.dataBufFactory = dataBufFactory;
        return this;
    }

    @Override
    @NonNull
    public RPCSender build() {
        Preconditions.checkArgument((this.channelSupplier != null ? 1 : 0) != 0, (Object)"channel supplier must be given");
        RPCClassMetadata classMetadata = this.classMetadata.freeze();
        return new DefaultRPCSender(classMetadata.targetClass(), this.sourceFactory, this.objectMapper, this.dataBufFactory, classMetadata, this.channelSupplier);
    }
}

