/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.sender;

import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.buffer.DataBufFactory;
import eu.cloudnetservice.driver.network.rpc.RPC;
import eu.cloudnetservice.driver.network.rpc.RPCSender;
import eu.cloudnetservice.driver.network.rpc.defaults.DefaultRPCProvider;
import eu.cloudnetservice.driver.network.rpc.defaults.rpc.DefaultRPC;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.network.rpc.introspec.RPCClassMetadata;
import eu.cloudnetservice.driver.network.rpc.introspec.RPCMethodMetadata;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class DefaultRPCSender
extends DefaultRPCProvider
implements RPCSender {
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private final RPCClassMetadata rpcTargetMeta;
    private final Supplier<NetworkChannel> channelSupplier;

    public DefaultRPCSender(@NonNull Class<?> targetClass, @NonNull RPCFactory sourceFactory, @NonNull ObjectMapper objectMapper, @NonNull DataBufFactory dataBufFactory, @NonNull RPCClassMetadata rpcTargetMeta, @NonNull Supplier<NetworkChannel> channelSupplier) {
        super(targetClass, sourceFactory, objectMapper, dataBufFactory);
        if (targetClass == null) {
            throw new NullPointerException("targetClass is marked non-null but is null");
        }
        if (sourceFactory == null) {
            throw new NullPointerException("sourceFactory is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (dataBufFactory == null) {
            throw new NullPointerException("dataBufFactory is marked non-null but is null");
        }
        if (rpcTargetMeta == null) {
            throw new NullPointerException("rpcTargetMeta is marked non-null but is null");
        }
        if (channelSupplier == null) {
            throw new NullPointerException("channelSupplier is marked non-null but is null");
        }
        this.rpcTargetMeta = rpcTargetMeta;
        this.channelSupplier = channelSupplier;
    }

    @Override
    @NonNull
    public RPC invokeCaller(Object ... args) {
        return this.invokeCallerWithOffset(1, args);
    }

    @Override
    @NonNull
    public RPC invokeCallerWithOffset(int callerStackOffset, Object ... args) {
        StackWalker.StackFrame callerFrame = (StackWalker.StackFrame)STACK_WALKER.walk(frameStream -> frameStream.skip(callerStackOffset + 1).findFirst()).orElseThrow(() -> new IllegalStateException("unable to resolve caller of method"));
        return this.invokeMethod(callerFrame.getMethodName(), callerFrame.getMethodType(), args);
    }

    @Override
    @NonNull
    public RPC invokeMethod(@NonNull String methodName, Object ... args) {
        if (methodName == null) {
            throw new NullPointerException("methodName is marked non-null but is null");
        }
        List<RPCMethodMetadata> matchingMethods = this.rpcTargetMeta.findMethods(meta -> {
            MethodType methodType = meta.methodType();
            return meta.name().equals(methodName) && methodType.parameterCount() == args.length;
        });
        if (matchingMethods.size() != 1) {
            throw new IllegalArgumentException(String.format("Cannot find distinct method to call in %s [searched for %s(%d params)], found %d matches", this.targetClass.getName(), methodName, args.length, matchingMethods.size()));
        }
        return this.invokeMethod(matchingMethods.getFirst(), args);
    }

    @Override
    @NonNull
    public RPC invokeMethod(@NonNull String methodName, @NonNull TypeDescriptor methodDesc, Object ... args) {
        if (methodName == null) {
            throw new NullPointerException("methodName is marked non-null but is null");
        }
        if (methodDesc == null) {
            throw new NullPointerException("methodDesc is marked non-null but is null");
        }
        RPCMethodMetadata methodMeta = this.rpcTargetMeta.findMethod(methodName, methodDesc);
        if (methodMeta == null) {
            throw new IllegalArgumentException(String.format("Cannot find a method matching %s%s in %s", methodName, methodDesc.descriptorString(), this.targetClass.getName()));
        }
        return this.invokeMethod(methodMeta, args);
    }

    @NonNull
    private RPC invokeMethod(@NonNull RPCMethodMetadata method, Object ... args) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        int expectedArgCount = method.methodType().parameterCount();
        if (expectedArgCount != args.length) {
            throw new IllegalArgumentException(String.format("Invalid argument count passed for method invocation. Expected %d, got %d", expectedArgCount, args.length));
        }
        Duration methodExecutionTimeout = method.executionTimeout();
        Duration timeout = methodExecutionTimeout != null ? methodExecutionTimeout : this.rpcTargetMeta.defaultRPCTimeout();
        return new DefaultRPC(this.targetClass, this.sourceFactory, this.objectMapper, this.dataBufFactory, this, this.channelSupplier, timeout, method, args);
    }
}

