/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.rpc;

import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.rpc.defaults.handler.util.RPCExceptionUtil;
import eu.cloudnetservice.driver.network.rpc.exception.RPCExecutionException;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import java.lang.reflect.Type;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.UnknownNullability;

record RPCResultMapper<T>(@NonNull Type expectedResultType, @NonNull ObjectMapper objectMapper) implements Function<Packet, T>
{
    @Generated
    public RPCResultMapper(@NonNull Type expectedResultType, @NonNull ObjectMapper objectMapper) {
        if (expectedResultType == null) {
            throw new NullPointerException("expectedResultType is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
    }

    @Override
    public @UnknownNullability T apply(@UnknownNullability Packet response) {
        DataBuf responseData = response.content();
        byte status = responseData.readByte();
        return switch (status) {
            case 0 -> this.objectMapper.readObject(responseData, this.expectedResultType);
            case 1 -> {
                RPCExceptionUtil.rethrowHandlingException(responseData);
                yield null;
            }
            case 2 -> {
                String detailMessage = responseData.readString();
                String exceptionMessage = String.format("RPC couldn't be processed due to bad input data: %s", detailMessage);
                throw new RPCExecutionException(exceptionMessage);
            }
            case 3 -> {
                String detailMessage = responseData.readString();
                String exceptionMessage = String.format("RPC couldn't be processed due to a server error: %s", detailMessage);
                throw new RPCExecutionException(exceptionMessage);
            }
            default -> {
                String exceptionMessage = String.format("Server responded with unknown status code: %d", status);
                throw new RPCExecutionException(exceptionMessage);
            }
        };
    }
}

