/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.rpc;

import eu.cloudnetservice.common.concurrent.TaskUtil;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.rpc.RPC;
import eu.cloudnetservice.driver.network.rpc.RPCChain;
import eu.cloudnetservice.driver.network.rpc.defaults.DefaultRPCProvider;
import eu.cloudnetservice.driver.network.rpc.defaults.rpc.RPCResultMapper;
import eu.cloudnetservice.driver.network.rpc.exception.RPCException;
import eu.cloudnetservice.driver.network.rpc.exception.RPCExecutionException;
import eu.cloudnetservice.driver.network.rpc.packet.RPCRequestPacket;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.NonNull;
import org.jetbrains.annotations.UnknownNullability;

public final class DefaultRPCChain
extends DefaultRPCProvider
implements RPCChain {
    private final RPC chainHead;
    private final RPC chainTail;
    private final List<RPC> fullChain;
    private final Supplier<NetworkChannel> channelSupplier;

    private DefaultRPCChain(@NonNull RPC chainHead, @NonNull RPC chainTail, @NonNull List<RPC> fullChain, @NonNull Supplier<NetworkChannel> channelSupplier) {
        super(chainHead.targetClass(), chainHead.sourceFactory(), chainHead.objectMapper(), chainHead.dataBufFactory());
        if (chainHead == null) {
            throw new NullPointerException("chainHead is marked non-null but is null");
        }
        if (chainTail == null) {
            throw new NullPointerException("chainTail is marked non-null but is null");
        }
        if (fullChain == null) {
            throw new NullPointerException("fullChain is marked non-null but is null");
        }
        if (channelSupplier == null) {
            throw new NullPointerException("channelSupplier is marked non-null but is null");
        }
        this.chainHead = chainHead;
        this.chainTail = chainTail;
        this.fullChain = Collections.unmodifiableList(fullChain);
        this.channelSupplier = channelSupplier;
    }

    @NonNull
    public static DefaultRPCChain of(@NonNull RPC root, @NonNull RPC next, @NonNull Supplier<NetworkChannel> channelSupplier) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (next == null) {
            throw new NullPointerException("next is marked non-null but is null");
        }
        if (channelSupplier == null) {
            throw new NullPointerException("channelSupplier is marked non-null but is null");
        }
        LinkedList<RPC> fullChain = new LinkedList<RPC>();
        fullChain.add(root);
        fullChain.add(next);
        return new DefaultRPCChain(root, next, fullChain, channelSupplier);
    }

    @Override
    @NonNull
    public RPCChain join(@NonNull RPC rpc) {
        if (rpc == null) {
            throw new NullPointerException("rpc is marked non-null but is null");
        }
        LinkedList<RPC> newChain = new LinkedList<RPC>(this.fullChain);
        newChain.add(rpc);
        return new DefaultRPCChain(this.chainHead, rpc, newChain, this.channelSupplier);
    }

    @Override
    @NonNull
    public RPC tail() {
        return this.chainTail;
    }

    @Override
    @NonNull
    public Collection<RPC> joins() {
        return this.fullChain;
    }

    @Override
    public void fireAndForget() {
        NetworkChannel targetNetworkChannel = this.channelSupplier.get();
        Objects.requireNonNull(targetNetworkChannel, "unable to get target network channel");
        this.fireAndForget(targetNetworkChannel);
    }

    @Override
    public <T> @UnknownNullability T fireSync() {
        NetworkChannel targetNetworkChannel = this.channelSupplier.get();
        Objects.requireNonNull(targetNetworkChannel, "unable to get target network channel");
        return this.fireSync(targetNetworkChannel);
    }

    @Override
    @NonNull
    public <T> CompletableFuture<T> fire() {
        NetworkChannel targetNetworkChannel = this.channelSupplier.get();
        Objects.requireNonNull(targetNetworkChannel, "unable to get target network channel");
        return this.fire(targetNetworkChannel);
    }

    @Override
    public void fireAndForget(@NonNull NetworkChannel component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        this.chainTail.dropResult();
        this.fireSync(component);
    }

    @Override
    @NonNull
    public <T> T fireSync(@NonNull NetworkChannel component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        try {
            CompletableFuture<T> queryTask = this.fire(component);
            T invocationResult = queryTask.get();
            if (this.chainTail.targetMethod().asyncReturnType()) {
                return (T)TaskUtil.finishedFuture(invocationResult);
            }
            return invocationResult;
        }
        catch (ExecutionException exception) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof RPCExecutionException) {
                RPCExecutionException rpcExecutionException = (RPCExecutionException)throwable;
                throw rpcExecutionException;
            }
            throw new RPCException(this, (Exception)exception);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new IllegalThreadStateException();
        }
    }

    @Override
    @NonNull
    public <T> CompletableFuture<T> fire(@NonNull NetworkChannel component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        DataBuf.Mutable buffer = this.dataBufFactory.createEmpty().writeInt(this.fullChain.size());
        for (RPC chainEntry : this.fullChain) {
            buffer.writeString(chainEntry.className()).writeString(chainEntry.methodName()).writeString(chainEntry.methodDescriptor());
            for (Object argument : chainEntry.arguments()) {
                this.objectMapper.writeObject(buffer, argument);
            }
        }
        if (this.chainTail.resultDropped()) {
            component.sendPacket((Packet)new RPCRequestPacket(buffer));
            return TaskUtil.finishedFuture(null);
        }
        CompletableFuture queryFuture = component.sendQueryAsync(new RPCRequestPacket(buffer)).thenApply((Function)new RPCResultMapper(this.chainTail.expectedResultType(), this.objectMapper));
        Duration timeout = this.chainTail.timeout();
        if (timeout != null) {
            long timeoutMillis = timeout.toMillis();
            queryFuture = queryFuture.orTimeout(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        return queryFuture;
    }
}

