/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.rpc;

import eu.cloudnetservice.common.concurrent.TaskUtil;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.buffer.DataBufFactory;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.rpc.RPC;
import eu.cloudnetservice.driver.network.rpc.RPCChain;
import eu.cloudnetservice.driver.network.rpc.RPCSender;
import eu.cloudnetservice.driver.network.rpc.defaults.DefaultRPCProvider;
import eu.cloudnetservice.driver.network.rpc.defaults.rpc.DefaultRPCChain;
import eu.cloudnetservice.driver.network.rpc.defaults.rpc.RPCResultMapper;
import eu.cloudnetservice.driver.network.rpc.exception.RPCException;
import eu.cloudnetservice.driver.network.rpc.exception.RPCExecutionException;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.network.rpc.introspec.RPCMethodMetadata;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import eu.cloudnetservice.driver.network.rpc.packet.RPCRequestPacket;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public final class DefaultRPC
extends DefaultRPCProvider
implements RPC {
    private final RPCSender sender;
    private final Supplier<NetworkChannel> channelSupplier;
    private final Object[] arguments;
    private final RPCMethodMetadata targetMethod;
    private boolean dropResult;
    private Duration executionTimeout;

    public DefaultRPC(@NonNull Class<?> targetClass, @NonNull RPCFactory sourceFactory, @NonNull ObjectMapper objectMapper, @NonNull DataBufFactory dataBufFactory, @NonNull RPCSender sender, @NonNull Supplier<NetworkChannel> channelSupplier, @Nullable Duration executionTimeout, @NonNull RPCMethodMetadata targetMethod, @NonNull Object[] arguments) {
        super(targetClass, sourceFactory, objectMapper, dataBufFactory);
        if (targetClass == null) {
            throw new NullPointerException("targetClass is marked non-null but is null");
        }
        if (sourceFactory == null) {
            throw new NullPointerException("sourceFactory is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (dataBufFactory == null) {
            throw new NullPointerException("dataBufFactory is marked non-null but is null");
        }
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (channelSupplier == null) {
            throw new NullPointerException("channelSupplier is marked non-null but is null");
        }
        if (targetMethod == null) {
            throw new NullPointerException("targetMethod is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        this.sender = sender;
        this.channelSupplier = channelSupplier;
        this.executionTimeout = executionTimeout;
        this.targetMethod = targetMethod;
        this.arguments = arguments;
        this.dropResult = targetMethod.executionResultIgnored();
    }

    @Override
    @NonNull
    public RPCChain join(@NonNull RPC rpc) {
        if (rpc == null) {
            throw new NullPointerException("rpc is marked non-null but is null");
        }
        return DefaultRPCChain.of(this, rpc, this.channelSupplier);
    }

    @Override
    @NonNull
    public RPCSender sender() {
        return this.sender;
    }

    @Override
    @NonNull
    public String className() {
        return this.targetClass.getName();
    }

    @Override
    @NonNull
    public String methodName() {
        return this.targetMethod.name();
    }

    @Override
    @NonNull
    public String methodDescriptor() {
        return this.targetMethod.methodType().descriptorString();
    }

    @Override
    @NonNull
    public Object[] arguments() {
        return this.arguments;
    }

    @Override
    @NonNull
    public Type expectedResultType() {
        return this.targetMethod.unwrappedReturnType();
    }

    @Override
    @NonNull
    public RPCMethodMetadata targetMethod() {
        return this.targetMethod;
    }

    @Override
    @NonNull
    public RPC timeout(@Nullable Duration timeout) {
        this.executionTimeout = timeout;
        return this;
    }

    @Override
    @Nullable
    public Duration timeout() {
        return this.executionTimeout;
    }

    @Override
    @NonNull
    public RPC dropResult() {
        this.dropResult = true;
        return this;
    }

    @Override
    public boolean resultDropped() {
        return this.dropResult;
    }

    @Override
    public void fireAndForget() {
        NetworkChannel targetNetworkChannel = this.channelSupplier.get();
        Objects.requireNonNull(targetNetworkChannel, "unable to get target network channel");
        this.fireAndForget(targetNetworkChannel);
    }

    @Override
    public <T> @UnknownNullability T fireSync() {
        NetworkChannel targetNetworkChannel = this.channelSupplier.get();
        Objects.requireNonNull(targetNetworkChannel, "unable to get target network channel");
        return this.fireSync(targetNetworkChannel);
    }

    @Override
    @NonNull
    public <T> CompletableFuture<T> fire() {
        NetworkChannel targetNetworkChannel = this.channelSupplier.get();
        Objects.requireNonNull(targetNetworkChannel, "unable to get target network channel");
        return this.fire(targetNetworkChannel);
    }

    @Override
    public void fireAndForget(@NonNull NetworkChannel component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        this.dropResult().fireSync(component);
    }

    @Override
    @Nullable
    public <T> T fireSync(@NonNull NetworkChannel component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        try {
            CompletableFuture<T> queryTask = this.fire(component);
            T invocationResult = queryTask.get();
            if (this.targetMethod.asyncReturnType()) {
                return (T)TaskUtil.finishedFuture(invocationResult);
            }
            return invocationResult;
        }
        catch (CancellationException | ExecutionException exception) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof RPCExecutionException) {
                RPCExecutionException executionException = (RPCExecutionException)throwable;
                throw executionException;
            }
            throw new RPCException(this, exception);
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            throw new IllegalThreadStateException();
        }
    }

    @Override
    @NonNull
    public <T> CompletableFuture<T> fire(@NonNull NetworkChannel component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        DataBuf.Mutable dataBuf = this.dataBufFactory.createEmpty().writeInt(1).writeString(this.className()).writeString(this.methodName()).writeString(this.methodDescriptor());
        for (Object argument : this.arguments) {
            this.objectMapper.writeObject(dataBuf, argument);
        }
        if (this.dropResult) {
            component.sendPacket((Packet)new RPCRequestPacket(dataBuf));
            return TaskUtil.finishedFuture(null);
        }
        CompletableFuture queryFuture = component.sendQueryAsync(new RPCRequestPacket(dataBuf)).thenApply((Function)new RPCResultMapper(this.expectedResultType(), this.objectMapper));
        if (this.executionTimeout != null) {
            long timeoutMillis = this.executionTimeout.toMillis();
            queryFuture = queryFuture.orTimeout(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        return queryFuture;
    }
}

