/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.object.serializers;

import eu.cloudnetservice.driver.network.rpc.defaults.object.serializers.FunctionalObjectSerializer;
import eu.cloudnetservice.driver.network.rpc.object.ObjectSerializer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public final class TimeObjectSerializer {
    public static final ObjectSerializer<Year> YEAR_SERIALIZER = FunctionalObjectSerializer.of(dataBuf -> Year.of(dataBuf.readInt()), (dataBuf, year) -> dataBuf.writeInt(year.getValue()));
    public static final ObjectSerializer<YearMonth> YEAR_MONTH_SERIALIZER = FunctionalObjectSerializer.of(dataBuf -> YearMonth.of(dataBuf.readInt(), dataBuf.readByte()), (dataBuf, yearMonth) -> {
        dataBuf.writeInt(yearMonth.getYear());
        dataBuf.writeByte((byte)yearMonth.getMonthValue());
    });
    public static final ObjectSerializer<MonthDay> MONTH_DAY_SERIALIZER = FunctionalObjectSerializer.of(dataBuf -> MonthDay.of(dataBuf.readByte(), (int)dataBuf.readByte()), (dataBuf, monthDay) -> {
        dataBuf.writeByte((byte)monthDay.getMonthValue());
        dataBuf.writeByte((byte)monthDay.getDayOfMonth());
    });
    public static final ObjectSerializer<ZoneId> ZONE_ID_SERIALIZER = FunctionalObjectSerializer.of(dataBuf -> ZoneId.of(dataBuf.readString()), (dataBuf, zoneId) -> dataBuf.writeString(zoneId.getId()));
    public static final ObjectSerializer<Duration> DURATION_SERIALIZER = FunctionalObjectSerializer.of(dataBuf -> Duration.ofSeconds(dataBuf.readLong(), dataBuf.readInt()), (dataBuf, duration) -> {
        dataBuf.writeLong(duration.getSeconds());
        dataBuf.writeInt(duration.getNano());
    });
    public static final ObjectSerializer<Period> PERIOD_SERIALIZER = FunctionalObjectSerializer.of(dataBuf -> Period.of(dataBuf.readInt(), dataBuf.readInt(), dataBuf.readInt()), (dataBuf, period) -> {
        dataBuf.writeInt(period.getYears());
        dataBuf.writeInt(period.getMonths());
        dataBuf.writeInt(period.getDays());
    });
    public static final ObjectSerializer<Instant> INSTANT_SERIALIZER = FunctionalObjectSerializer.of(dataBuf -> Instant.ofEpochSecond(dataBuf.readLong(), dataBuf.readInt()), (dataBuf, instant) -> {
        dataBuf.writeLong(instant.getEpochSecond());
        dataBuf.writeInt(instant.getNano());
    });
    public static final ObjectSerializer<LocalDate> LOCAL_DATE_SERIALIZER = FunctionalObjectSerializer.of(dataBuf -> LocalDate.of(dataBuf.readInt(), dataBuf.readByte(), (int)dataBuf.readByte()), (dataBuf, localDate) -> {
        dataBuf.writeInt(localDate.getYear());
        dataBuf.writeByte((byte)localDate.getMonthValue());
        dataBuf.writeByte((byte)localDate.getDayOfMonth());
    });
    public static final ObjectSerializer<LocalTime> LOCAL_TIME_SERIALIZER = FunctionalObjectSerializer.of(dataBuf -> {
        byte hour = dataBuf.readByte();
        if (hour < 0) {
            return LocalTime.of(~hour, 0);
        }
        byte minute = dataBuf.readByte();
        if (minute < 0) {
            return LocalTime.of(hour, ~minute);
        }
        byte second = dataBuf.readByte();
        if (second < 0) {
            return LocalTime.of(hour, minute, ~second);
        }
        int nano = dataBuf.readInt();
        return LocalTime.of(hour, minute, second, nano);
    }, (dataBuf, localTime) -> {
        int nano = localTime.getNano();
        int second = localTime.getSecond();
        int minute = localTime.getMinute();
        int hour = localTime.getHour();
        if (nano == 0) {
            if (second == 0) {
                if (minute == 0) {
                    dataBuf.writeByte((byte)(~hour));
                } else {
                    dataBuf.writeByte((byte)hour);
                    dataBuf.writeByte((byte)(~minute));
                }
            } else {
                dataBuf.writeByte((byte)hour);
                dataBuf.writeByte((byte)minute);
                dataBuf.writeByte((byte)(~second));
            }
        } else {
            dataBuf.writeByte((byte)hour);
            dataBuf.writeByte((byte)minute);
            dataBuf.writeByte((byte)second);
            dataBuf.writeInt(nano);
        }
    });
    public static final ObjectSerializer<LocalDateTime> LOCAL_DATE_TIME_SERIALIZER = FunctionalObjectSerializer.of(dataBuf -> {
        LocalDate date = dataBuf.readObject(LocalDate.class);
        LocalTime time = dataBuf.readObject(LocalTime.class);
        return LocalDateTime.of(date, time);
    }, (dataBuf, localDateTime) -> {
        dataBuf.writeObject(localDateTime.toLocalDate());
        dataBuf.writeObject(localDateTime.toLocalTime());
    });
    public static final ObjectSerializer<ZonedDateTime> ZONED_DATE_TIME_SERIALIZER = FunctionalObjectSerializer.of(dataBuf -> {
        ZoneId zoneId = dataBuf.readObject(ZoneId.class);
        LocalDateTime dateTime = dataBuf.readObject(LocalDateTime.class);
        return ZonedDateTime.of(dateTime, zoneId);
    }, (dataBuf, zonedDateTime) -> {
        dataBuf.writeObject(zonedDateTime.getZone());
        dataBuf.writeObject(zonedDateTime.toLocalDateTime());
    });
    public static final ObjectSerializer<OffsetTime> OFFSET_TIME_SERIALIZER = FunctionalObjectSerializer.of(dataBuf -> {
        LocalTime time = dataBuf.readObject(LocalTime.class);
        ZoneOffset offset = ZoneOffset.ofTotalSeconds(dataBuf.readInt());
        return OffsetTime.of(time, offset);
    }, (dataBuf, offsetTime) -> {
        dataBuf.writeObject(offsetTime.toLocalTime());
        dataBuf.writeInt(offsetTime.getOffset().getTotalSeconds());
    });
    public static final ObjectSerializer<OffsetDateTime> OFFSET_DATE_TIME_SERIALIZER = FunctionalObjectSerializer.of(dataBuf -> {
        LocalDateTime dateTime = dataBuf.readObject(LocalDateTime.class);
        ZoneOffset offset = ZoneOffset.ofTotalSeconds(dataBuf.readInt());
        return OffsetDateTime.of(dateTime, offset);
    }, (dataBuf, offsetTime) -> {
        dataBuf.writeObject(offsetTime.toLocalDateTime());
        dataBuf.writeInt(offsetTime.getOffset().getTotalSeconds());
    });

    private TimeObjectSerializer() {
        throw new UnsupportedOperationException();
    }
}

