/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.object.serializers;

import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import eu.cloudnetservice.driver.network.rpc.object.ObjectSerializer;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import lombok.NonNull;

public final class OptionalObjectSerializer
implements ObjectSerializer<Optional<?>> {
    @Override
    @NonNull
    public Optional<?> read(@NonNull DataBuf source, @NonNull Type type, @NonNull ObjectMapper caller) {
        ParameterizedType pt;
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        if (!(type instanceof ParameterizedType) || !GenericTypeReflector.isFullyBound((Type)(pt = (ParameterizedType)type))) {
            throw new IllegalArgumentException(String.format("expected fully bound parameterized type to deserialize Optional, got %s", type));
        }
        Type[] typeArguments = pt.getActualTypeArguments();
        if (typeArguments.length != 1) {
            throw new IllegalArgumentException(String.format("expected 1 type argument to deserialize Optional, got %d", typeArguments.length));
        }
        Object deserializedValue = caller.readObject(source, typeArguments[0]);
        return Optional.ofNullable(deserializedValue);
    }

    @Override
    public void write(@NonNull DataBuf.Mutable dataBuf, @NonNull Optional<?> object, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        caller.writeObject(dataBuf, object.orElse(null));
    }
}

