/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.object.serializers;

import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import eu.cloudnetservice.driver.network.rpc.object.ObjectSerializer;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.IntFunction;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public final class MapObjectSerializer
implements ObjectSerializer<Map<?, ?>> {
    private final IntFunction<Map<Object, Object>> mapFactory;

    private MapObjectSerializer(@NonNull IntFunction<Map<Object, Object>> mapFactory) {
        if (mapFactory == null) {
            throw new NullPointerException("mapFactory is marked non-null but is null");
        }
        this.mapFactory = mapFactory;
    }

    @NonNull
    public static MapObjectSerializer of(@NonNull IntFunction<Map<Object, Object>> mapFactory) {
        if (mapFactory == null) {
            throw new NullPointerException("mapFactory is marked non-null but is null");
        }
        return new MapObjectSerializer(mapFactory);
    }

    @Override
    @Nullable
    public Map<?, ?> read(@NonNull DataBuf source, @NonNull Type type, @NonNull ObjectMapper caller) {
        ParameterizedType pt;
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        if (!(type instanceof ParameterizedType) || !GenericTypeReflector.isFullyBound((Type)(pt = (ParameterizedType)type))) {
            throw new IllegalArgumentException(String.format("expected fully bound parameterized type to deserialize Map, got %s", type));
        }
        Type[] typeArguments = pt.getActualTypeArguments();
        if (typeArguments.length != 2) {
            throw new IllegalArgumentException(String.format("expected 2 type arguments to deserialize Map, got %d", typeArguments.length));
        }
        int mapSize = source.readInt();
        Map<Object, Object> mapInstance = this.mapFactory.apply(mapSize);
        for (int index = 0; index < mapSize; ++index) {
            Object entryKey = caller.readObject(source, typeArguments[0]);
            Object entryValue = caller.readObject(source, typeArguments[1]);
            mapInstance.put(entryKey, entryValue);
        }
        return mapInstance;
    }

    @Override
    public void write(@NonNull DataBuf.Mutable dataBuf, @NonNull Map<?, ?> object, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        dataBuf.writeInt(object.size());
        for (Map.Entry<?, ?> entry : object.entrySet()) {
            caller.writeObject(dataBuf, entry.getKey());
            caller.writeObject(dataBuf, entry.getValue());
        }
    }
}

