/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.object.serializers;

import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import eu.cloudnetservice.driver.network.rpc.object.ObjectSerializer;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.function.IntFunction;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public final class CollectionObjectSerializer
implements ObjectSerializer<Collection<?>> {
    private final IntFunction<Collection<Object>> collectionFactory;

    private CollectionObjectSerializer(@NonNull IntFunction<Collection<Object>> collectionFactory) {
        if (collectionFactory == null) {
            throw new NullPointerException("collectionFactory is marked non-null but is null");
        }
        this.collectionFactory = collectionFactory;
    }

    @NonNull
    public static CollectionObjectSerializer of(@NonNull IntFunction<Collection<Object>> collectionFactory) {
        if (collectionFactory == null) {
            throw new NullPointerException("collectionFactory is marked non-null but is null");
        }
        return new CollectionObjectSerializer(collectionFactory);
    }

    @Override
    @Nullable
    public Collection<?> read(@NonNull DataBuf source, @NonNull Type type, @NonNull ObjectMapper caller) {
        ParameterizedType pt;
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        if (!(type instanceof ParameterizedType) || !GenericTypeReflector.isFullyBound((Type)(pt = (ParameterizedType)type))) {
            throw new IllegalArgumentException(String.format("expected fully bound parameterized type to deserialize Collection, got %s", type));
        }
        Type[] typeArguments = pt.getActualTypeArguments();
        if (typeArguments.length != 1) {
            throw new IllegalArgumentException(String.format("expected 1 type argument to deserialize Collection, got %d", typeArguments.length));
        }
        int collectionSize = source.readInt();
        Collection<Object> collection = this.collectionFactory.apply(collectionSize);
        for (int index = 0; index < collectionSize; ++index) {
            Object entry = caller.readObject(source, typeArguments[0]);
            collection.add(entry);
        }
        return collection;
    }

    @Override
    public void write(@NonNull DataBuf.Mutable dataBuf, @NonNull Collection<?> object, @NonNull Type type, @NonNull ObjectMapper caller) {
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (caller == null) {
            throw new NullPointerException("caller is marked non-null but is null");
        }
        dataBuf.writeInt(object.size());
        for (Object entry : object) {
            caller.writeObject(dataBuf, entry);
        }
    }
}

