/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.object.data;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
final class AllocationStatistic {
    private static final VarHandle STATISTIC_HOLDER_UPDATER;
    private long[] statisticHolder = new long[2];

    AllocationStatistic() {
    }

    public void add(int allocatedBytes) {
        if (allocatedBytes < 0) {
            return;
        }
        long[] currentRef = this.statisticHolder;
        long prevAllocatedBytes = currentRef[0];
        long prevAllocationCount = currentRef[1];
        long newAllocatedBytes = prevAllocatedBytes + (long)allocatedBytes;
        if (newAllocatedBytes >= prevAllocatedBytes) {
            long[] newHolder = new long[]{newAllocatedBytes, ++prevAllocationCount};
            STATISTIC_HOLDER_UPDATER.compareAndSet(this, currentRef, newHolder);
        }
    }

    public int average() {
        long[] currentRef = this.statisticHolder;
        long allocatedBytes = currentRef[0];
        long allocationCount = currentRef[1];
        if (allocationCount > 0L) {
            return Math.toIntExact(allocatedBytes / allocationCount);
        }
        return 0;
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            STATISTIC_HOLDER_UPDATER = lookup.findVarHandle(AllocationStatistic.class, "statisticHolder", long[].class);
        }
        catch (IllegalAccessException | NoSuchFieldException exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }
}

