/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.handler.util;

import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.rpc.exception.RPCExecutionException;
import eu.cloudnetservice.driver.network.rpc.listener.RPCPacketListener;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

@ApiStatus.Internal
public final class RPCExceptionUtil {
    public static final StackTraceElement[] UNASSIGNED_STACK = new StackTraceElement[0];
    private static final String RPC_LISTENER_HANDLE_METHOD = "postRPCRequestToHandler";
    private static final String RPC_LISTENER_CLASS_BIN_NAME = RPCPacketListener.class.getName();

    private RPCExceptionUtil() {
        throw new UnsupportedOperationException();
    }

    @Contract(value="_, _ -> param1")
    @NonNull
    public static DataBuf serializeHandlingException(@NonNull DataBuf.Mutable target, @NonNull Throwable throwable) {
        StackTraceElement stacktraceElement;
        int index;
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (throwable == null) {
            throw new NullPointerException("throwable is marked non-null but is null");
        }
        target.writeString(throwable.getClass().getSimpleName()).writeNullable(throwable.getMessage(), DataBuf.Mutable::writeString);
        StackTraceElement[] stacktrace = throwable.getStackTrace();
        if (stacktrace.length == 0) {
            return target.writeInt(0);
        }
        int cutoffIndex = -1;
        for (index = stacktrace.length - 1; index >= 0; --index) {
            stacktraceElement = stacktrace[index];
            if (!stacktraceElement.getClassName().equals(RPC_LISTENER_CLASS_BIN_NAME) || !stacktraceElement.getMethodName().equals(RPC_LISTENER_HANDLE_METHOD)) continue;
            cutoffIndex = index;
            break;
        }
        if (cutoffIndex != -1) {
            target.writeInt(cutoffIndex);
            for (index = 0; index < cutoffIndex; ++index) {
                stacktraceElement = stacktrace[index];
                RPCExceptionUtil.serializeStacktraceElement(target, stacktraceElement);
            }
        } else {
            target.writeInt(stacktrace.length);
            for (StackTraceElement stacktraceElement2 : stacktrace) {
                RPCExceptionUtil.serializeStacktraceElement(target, stacktraceElement2);
            }
        }
        return target;
    }

    @Contract(value="_ -> fail")
    public static void rethrowHandlingException(@NonNull DataBuf source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        String exceptionClassName = source.readString();
        String exceptionMessage = source.readNullable(DataBuf::readString, "<no message provided>");
        int stacktraceElementCount = source.readInt();
        if (stacktraceElementCount == 0) {
            RPCExecutionException executionException = new RPCExecutionException(exceptionClassName, exceptionMessage);
            executionException.setStackTrace(UNASSIGNED_STACK);
            throw executionException;
        }
        StackTraceElement[] stacktrace = new StackTraceElement[stacktraceElementCount];
        for (int index = 0; index < stacktraceElementCount; ++index) {
            StackTraceElement stacktraceElement;
            String classloaderName = source.readNullable(DataBuf::readString);
            String moduleName = source.readNullable(DataBuf::readString);
            String className = source.readString();
            String methodName = source.readString();
            String fileName = source.readNullable(DataBuf::readString);
            int lineNumber = source.readInt();
            stacktrace[index] = stacktraceElement = new StackTraceElement(classloaderName, moduleName, null, className, methodName, fileName, lineNumber);
        }
        RPCExecutionException executionException = new RPCExecutionException(exceptionClassName, exceptionMessage);
        executionException.setStackTrace(stacktrace);
        throw executionException;
    }

    private static void serializeStacktraceElement(@NonNull DataBuf.Mutable target, @NonNull StackTraceElement element) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        target.writeNullable(element.getClassLoaderName(), DataBuf.Mutable::writeString).writeNullable(element.getModuleName(), DataBuf.Mutable::writeString).writeString(element.getClassName()).writeString(element.getMethodName()).writeNullable(element.getFileName(), DataBuf.Mutable::writeString).writeInt(element.getLineNumber());
    }
}

