/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.handler.invoker;

import eu.cloudnetservice.driver.network.rpc.defaults.handler.invoker.MethodInvoker;
import eu.cloudnetservice.driver.network.rpc.introspec.RPCMethodMetadata;
import eu.cloudnetservice.driver.util.CodeGenerationUtil;
import java.lang.classfile.ClassFile;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class MethodInvokerGenerator {
    private static final String MI_CALL_METHOD_NAME = "callMethod";
    private static final ClassDesc CD_METHOD_INVOKER = ClassDesc.of(MethodInvoker.class.getName());
    private static final MethodTypeDesc MTD_MI_CALL_METHOD = MethodTypeDesc.of(ConstantDescs.CD_Object, ConstantDescs.CD_Object, ConstantDescs.CD_Object.arrayType());
    private static final MethodType MI_CONSTRUCTOR_TYPE = MethodType.methodType(Void.TYPE);

    @NonNull
    public static MethodInvoker makeMethodInvoker(@NonNull RPCMethodMetadata targetMethod) {
        if (targetMethod == null) {
            throw new NullPointerException("targetMethod is marked non-null but is null");
        }
        ClassDesc ownerClassDesc = ClassDesc.ofDescriptor(targetMethod.definingClass().descriptorString());
        ClassDesc classDesc = ownerClassDesc.nested("RPCInvoker", targetMethod.name());
        byte[] classFileBytes = ClassFile.of().build(classDesc, classBuilder -> {
            classBuilder.withInterfaceSymbols(new ClassDesc[]{CD_METHOD_INVOKER});
            classBuilder.withMethodBody("<init>", ConstantDescs.MTD_void, 1, code -> code.aload(0).invokespecial(ConstantDescs.CD_Object, "<init>", ConstantDescs.MTD_void).return_());
            classBuilder.withMethodBody(MI_CALL_METHOD_NAME, MTD_MI_CALL_METHOD, 1, code -> {
                String returnDescriptor;
                code.aload(1).checkcast(ownerClassDesc);
                MethodType targetMethodType = targetMethod.methodType();
                int targetMethodParameterCount = targetMethodType.parameterCount();
                for (int index = 0; index < targetMethodParameterCount; ++index) {
                    code.aload(2).ldc((ConstantDesc)Integer.valueOf(index)).aaload();
                    TypeDescriptor.OfField parameterType = targetMethodType.parameterType(index);
                    if (((Class)parameterType).isPrimitive()) {
                        CodeGenerationUtil.unboxPrimitive(code, ((Class)parameterType).descriptorString());
                        continue;
                    }
                    ClassDesc targetTypeDesc = ClassDesc.ofDescriptor(((Class)parameterType).descriptorString());
                    code.checkcast(targetTypeDesc);
                }
                MethodTypeDesc targetMethodTypeDesc = MethodTypeDesc.ofDescriptor(targetMethod.methodType().descriptorString());
                if (targetMethod.definingClass().isInterface()) {
                    code.invokeinterface(ownerClassDesc, targetMethod.name(), targetMethodTypeDesc);
                } else {
                    code.invokevirtual(ownerClassDesc, targetMethod.name(), targetMethodTypeDesc);
                }
                switch (returnDescriptor = targetMethodTypeDesc.returnType().descriptorString()) {
                    case "V": {
                        code.aconst_null();
                        break;
                    }
                    case "Z": 
                    case "B": 
                    case "S": 
                    case "C": 
                    case "I": 
                    case "J": 
                    case "F": 
                    case "D": {
                        CodeGenerationUtil.boxPrimitive(code, returnDescriptor);
                    }
                }
                code.areturn();
            });
        });
        try {
            MethodHandles.Lookup classLookup = CodeGenerationUtil.defineNestedClass(targetMethod.definingClass(), classFileBytes);
            MethodHandle noArgsConstructor = classLookup.findConstructor(classLookup.lookupClass(), MI_CONSTRUCTOR_TYPE);
            return noArgsConstructor.invoke();
        }
        catch (Throwable throwable) {
            throw new AssertionError("unable to define or constructor method accessor", throwable);
        }
    }
}

