/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.handler;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.rpc.handler.RPCInvocationContext;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultRPCInvocationContext
implements RPCInvocationContext {
    private final String methodName;
    private final String methodDescriptor;
    private final DataBuf argumentInformation;
    private final Object workingInstance;

    private DefaultRPCInvocationContext(@NonNull String methodName, @NonNull String methodDescriptor, @NonNull DataBuf argumentInformation, @Nullable Object workingInstance) {
        if (methodName == null) {
            throw new NullPointerException("methodName is marked non-null but is null");
        }
        if (methodDescriptor == null) {
            throw new NullPointerException("methodDescriptor is marked non-null but is null");
        }
        if (argumentInformation == null) {
            throw new NullPointerException("argumentInformation is marked non-null but is null");
        }
        this.methodName = methodName;
        this.methodDescriptor = methodDescriptor;
        this.argumentInformation = argumentInformation;
        this.workingInstance = workingInstance;
    }

    @Override
    @NonNull
    public String methodName() {
        return this.methodName;
    }

    @Override
    @NonNull
    public String methodDescriptor() {
        return this.methodDescriptor;
    }

    @Override
    @NonNull
    public DataBuf argumentInformation() {
        return this.argumentInformation;
    }

    @Override
    @Nullable
    public Object workingInstance() {
        return this.workingInstance;
    }

    public static final class Builder
    implements RPCInvocationContext.Builder {
        private String methodName;
        private String methodDescriptor;
        private DataBuf argumentInformation;
        private Object workingInstance;

        @Override
        @NonNull
        public RPCInvocationContext.Builder methodName(@NonNull String methodName) {
            if (methodName == null) {
                throw new NullPointerException("methodName is marked non-null but is null");
            }
            this.methodName = methodName;
            return this;
        }

        @Override
        @NonNull
        public RPCInvocationContext.Builder methodDescriptor(@NonNull String methodDescriptor) {
            if (methodDescriptor == null) {
                throw new NullPointerException("methodDescriptor is marked non-null but is null");
            }
            this.methodDescriptor = methodDescriptor;
            return this;
        }

        @Override
        @NonNull
        public RPCInvocationContext.Builder argumentInformation(@NonNull DataBuf information) {
            if (information == null) {
                throw new NullPointerException("information is marked non-null but is null");
            }
            this.argumentInformation = information;
            return this;
        }

        @Override
        @NonNull
        public RPCInvocationContext.Builder workingInstance(@Nullable Object instance) {
            this.workingInstance = instance;
            return this;
        }

        @Override
        @NonNull
        public RPCInvocationContext build() {
            Preconditions.checkNotNull((Object)this.methodName, (Object)"method name must be given");
            Preconditions.checkNotNull((Object)this.methodDescriptor, (Object)"method descriptor must be given");
            Preconditions.checkNotNull((Object)this.argumentInformation, (Object)"argument info buffer must be given");
            return new DefaultRPCInvocationContext(this.methodName, this.methodDescriptor, this.argumentInformation, this.workingInstance);
        }
    }
}

