/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.handler;

import dev.derklaro.aerogel.auto.Provides;
import eu.cloudnetservice.driver.network.rpc.handler.RPCHandler;
import eu.cloudnetservice.driver.network.rpc.handler.RPCHandlerRegistry;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

@Singleton
@Provides(value={RPCHandlerRegistry.class})
public class DefaultRPCHandlerRegistry
implements RPCHandlerRegistry {
    protected final Map<String, RPCHandler> handlers = new ConcurrentHashMap<String, RPCHandler>();

    @Override
    @NonNull
    public @UnmodifiableView Map<String, RPCHandler> registeredHandlers() {
        return Collections.unmodifiableMap(this.handlers);
    }

    @Override
    public boolean hasHandler(@NonNull Class<?> targetClass) {
        if (targetClass == null) {
            throw new NullPointerException("targetClass is marked non-null but is null");
        }
        return this.hasHandler(targetClass.getName());
    }

    @Override
    public boolean hasHandler(@NonNull String targetClassName) {
        if (targetClassName == null) {
            throw new NullPointerException("targetClassName is marked non-null but is null");
        }
        return this.handlers.containsKey(targetClassName);
    }

    @Override
    @Nullable
    public RPCHandler handler(@NonNull Class<?> targetClass) {
        if (targetClass == null) {
            throw new NullPointerException("targetClass is marked non-null but is null");
        }
        return this.handler(targetClass.getName());
    }

    @Override
    @Nullable
    public RPCHandler handler(@NonNull String targetClassName) {
        if (targetClassName == null) {
            throw new NullPointerException("targetClassName is marked non-null but is null");
        }
        return this.handlers.get(targetClassName);
    }

    @Override
    public boolean registerHandler(@NonNull RPCHandler rpcHandler) {
        if (rpcHandler == null) {
            throw new NullPointerException("rpcHandler is marked non-null but is null");
        }
        return this.handlers.put(rpcHandler.targetClass().getName(), rpcHandler) == null;
    }

    @Override
    public boolean unregisterHandler(@NonNull RPCHandler rpcHandler) {
        if (rpcHandler == null) {
            throw new NullPointerException("rpcHandler is marked non-null but is null");
        }
        RPCHandler handler = this.handler(rpcHandler.targetClass());
        if (handler == rpcHandler) {
            this.handlers.remove(handler.targetClass().getName());
            return true;
        }
        return false;
    }

    @Override
    public boolean unregisterHandler(@NonNull Class<?> rpcHandlerTargetClass) {
        if (rpcHandlerTargetClass == null) {
            throw new NullPointerException("rpcHandlerTargetClass is marked non-null but is null");
        }
        return this.unregisterHandler(rpcHandlerTargetClass.getName());
    }

    @Override
    public boolean unregisterHandler(@NonNull String rpcHandlerTargetClassName) {
        if (rpcHandlerTargetClassName == null) {
            throw new NullPointerException("rpcHandlerTargetClassName is marked non-null but is null");
        }
        return this.handlers.remove(rpcHandlerTargetClassName) != null;
    }

    @Override
    public void unregisterHandlers(@NonNull ClassLoader classLoader) {
        if (classLoader == null) {
            throw new NullPointerException("classLoader is marked non-null but is null");
        }
        for (Map.Entry<String, RPCHandler> entry : this.handlers.entrySet()) {
            if (!entry.getValue().getClass().getClassLoader().equals(classLoader)) continue;
            this.handlers.remove(entry.getKey(), entry.getValue());
        }
    }
}

