/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.handler;

import eu.cloudnetservice.driver.network.buffer.DataBufFactory;
import eu.cloudnetservice.driver.network.rpc.defaults.handler.DefaultRPCHandler;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.network.rpc.handler.RPCHandler;
import eu.cloudnetservice.driver.network.rpc.introspec.RPCClassMetadata;
import eu.cloudnetservice.driver.network.rpc.object.ObjectMapper;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultRPCHandlerBuilder<T>
implements RPCHandler.Builder<T> {
    private final RPCFactory sourceFactory;
    private final RPCClassMetadata classMetadata;
    private Object boundInstance;
    private ObjectMapper objectMapper;
    private DataBufFactory dataBufFactory;

    public DefaultRPCHandlerBuilder(@NonNull RPCFactory sourceFactory, @NonNull RPCClassMetadata classMetadata, @NonNull ObjectMapper objectMapper, @NonNull DataBufFactory dataBufFactory) {
        if (sourceFactory == null) {
            throw new NullPointerException("sourceFactory is marked non-null but is null");
        }
        if (classMetadata == null) {
            throw new NullPointerException("classMetadata is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (dataBufFactory == null) {
            throw new NullPointerException("dataBufFactory is marked non-null but is null");
        }
        this.sourceFactory = sourceFactory;
        this.classMetadata = classMetadata;
        this.objectMapper = objectMapper;
        this.dataBufFactory = dataBufFactory;
    }

    @Override
    @NonNull
    public RPCHandler.Builder<T> targetInstance(@Nullable Object instance) {
        this.boundInstance = instance;
        return this;
    }

    @Override
    @NonNull
    public RPCHandler.Builder<T> objectMapper(@NonNull ObjectMapper objectMapper) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        this.objectMapper = objectMapper;
        return this;
    }

    @Override
    @NonNull
    public RPCHandler.Builder<T> dataBufFactory(@NonNull DataBufFactory dataBufFactory) {
        if (dataBufFactory == null) {
            throw new NullPointerException("dataBufFactory is marked non-null but is null");
        }
        this.dataBufFactory = dataBufFactory;
        return this;
    }

    @Override
    @NonNull
    public RPCHandler build() {
        RPCClassMetadata classMetadata = this.classMetadata.freeze();
        return new DefaultRPCHandler(this.sourceFactory, this.objectMapper, this.dataBufFactory, this.boundInstance, classMetadata);
    }
}

