/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.generation;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.rpc.ChainableRPC;
import eu.cloudnetservice.driver.network.rpc.RPCSender;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public sealed class RPCInternalInstanceFactory {
    static final MethodType MT_BASIC_IMPLEMENTATION_CONSTRUCTOR = MethodType.methodType(Void.TYPE, Supplier.class, RPCSender.class, ChainableRPC.class, Object[].class);
    static final MethodTypeDesc MTD_BASIC_IMPLEMENTATION_CONSTRUCTOR = MethodTypeDesc.ofDescriptor(MT_BASIC_IMPLEMENTATION_CONSTRUCTOR.descriptorString());
    private final Runnable allocationNotifier;
    private final int userArgCount;
    private final RPCSender fallbackClassRPCSender;
    private final RPCInternalInstanceFactory[] additionalInstanceFactories;
    private final MethodHandle constructorMethodHandle;

    private RPCInternalInstanceFactory() {
        this.allocationNotifier = null;
        this.userArgCount = 0;
        this.fallbackClassRPCSender = null;
        this.additionalInstanceFactories = null;
        this.constructorMethodHandle = null;
    }

    private RPCInternalInstanceFactory(int userArgCount, @NonNull Runnable allocationNotifier, @NonNull RPCSender fallbackClassRPCSender, @NonNull RPCInternalInstanceFactory[] additionalInstanceFactories, @NonNull MethodHandle constructorMethodHandle) {
        if (allocationNotifier == null) {
            throw new NullPointerException("allocationNotifier is marked non-null but is null");
        }
        if (fallbackClassRPCSender == null) {
            throw new NullPointerException("fallbackClassRPCSender is marked non-null but is null");
        }
        if (additionalInstanceFactories == null) {
            throw new NullPointerException("additionalInstanceFactories is marked non-null but is null");
        }
        if (constructorMethodHandle == null) {
            throw new NullPointerException("constructorMethodHandle is marked non-null but is null");
        }
        this.allocationNotifier = allocationNotifier;
        this.userArgCount = userArgCount;
        this.fallbackClassRPCSender = fallbackClassRPCSender;
        this.additionalInstanceFactories = additionalInstanceFactories;
        this.constructorMethodHandle = constructorMethodHandle;
    }

    @NonNull
    public static RPCInternalInstanceFactory make(int userArgCount, @NonNull MethodHandles.Lookup lookup, @NonNull Runnable allocationNotifier, @NonNull RPCSender classRPCSender, @NonNull RPCInternalInstanceFactory[] additionalInstanceFactories) {
        if (lookup == null) {
            throw new NullPointerException("lookup is marked non-null but is null");
        }
        if (allocationNotifier == null) {
            throw new NullPointerException("allocationNotifier is marked non-null but is null");
        }
        if (classRPCSender == null) {
            throw new NullPointerException("classRPCSender is marked non-null but is null");
        }
        if (additionalInstanceFactories == null) {
            throw new NullPointerException("additionalInstanceFactories is marked non-null but is null");
        }
        try {
            if (additionalInstanceFactories.length == 0) {
                MethodHandle constructorHandle = lookup.findConstructor(lookup.lookupClass(), MT_BASIC_IMPLEMENTATION_CONSTRUCTOR);
                return new RPCInternalInstanceFactory(userArgCount, allocationNotifier, classRPCSender, additionalInstanceFactories, constructorHandle);
            }
            Object[] instanceFactoryParamTypes = new Class[additionalInstanceFactories.length];
            Arrays.fill(instanceFactoryParamTypes, RPCInternalInstanceFactory.class);
            MethodType methodType = MT_BASIC_IMPLEMENTATION_CONSTRUCTOR.appendParameterTypes((Class<?>[])instanceFactoryParamTypes);
            MethodHandle directConstructorHandle = lookup.findConstructor(lookup.lookupClass(), methodType);
            MethodHandle spreadingConstructorHandle = directConstructorHandle.asSpreader(MT_BASIC_IMPLEMENTATION_CONSTRUCTOR.parameterCount(), RPCInternalInstanceFactory[].class, additionalInstanceFactories.length);
            return new RPCInternalInstanceFactory(userArgCount, allocationNotifier, classRPCSender, additionalInstanceFactories, spreadingConstructorHandle);
        }
        catch (IllegalAccessException | NoSuchMethodException exception) {
            throw new IllegalStateException("unable to resolve constructor in generated rpc class", exception);
        }
    }

    @NonNull
    public Object constructInstance(@Nullable ChainableRPC baseRPC, @NonNull Supplier<NetworkChannel> channelSupplier, @NonNull Object[] additionalConstructorArgs) {
        if (channelSupplier == null) {
            throw new NullPointerException("channelSupplier is marked non-null but is null");
        }
        if (additionalConstructorArgs == null) {
            throw new NullPointerException("additionalConstructorArgs is marked non-null but is null");
        }
        return this.constructInstance(baseRPC, null, channelSupplier, additionalConstructorArgs);
    }

    @NonNull
    public Object constructInstance(@Nullable ChainableRPC baseRPC, @Nullable RPCSender classRPCSender, @NonNull Supplier<NetworkChannel> channelSupplier, @NonNull Object[] additionalConstructorArgs) {
        if (channelSupplier == null) {
            throw new NullPointerException("channelSupplier is marked non-null but is null");
        }
        if (additionalConstructorArgs == null) {
            throw new NullPointerException("additionalConstructorArgs is marked non-null but is null");
        }
        Objects.requireNonNull(this.allocationNotifier, "call to super from TempRPCInternalInstanceFactory");
        Objects.requireNonNull(this.constructorMethodHandle, "call to super from TempRPCInternalInstanceFactory");
        Objects.requireNonNull(this.additionalInstanceFactories, "call to super from TempRPCInternalInstanceFactory");
        if (additionalConstructorArgs.length != this.userArgCount) {
            throw new IllegalArgumentException(String.format("illegal additional constructor parameter count, expected %d, got %d", this.userArgCount, additionalConstructorArgs.length));
        }
        this.allocationNotifier.run();
        try {
            this.replaceSpecialArgs(additionalConstructorArgs, baseRPC, channelSupplier);
            RPCSender rpcSender = Objects.requireNonNullElse(classRPCSender, this.fallbackClassRPCSender);
            if (this.additionalInstanceFactories.length == 0) {
                return this.constructorMethodHandle.invoke(channelSupplier, rpcSender, baseRPC, additionalConstructorArgs);
            }
            return this.constructorMethodHandle.invoke(channelSupplier, rpcSender, baseRPC, additionalConstructorArgs, this.additionalInstanceFactories);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("unable to construct instance of generated rpc class", throwable);
        }
    }

    private void replaceSpecialArgs(Object[] args, @Nullable ChainableRPC baseRPC, @NonNull Supplier<NetworkChannel> channelSupplier) {
        if (channelSupplier == null) {
            throw new NullPointerException("channelSupplier is marked non-null but is null");
        }
        block5: for (int index = 0; index < args.length; ++index) {
            Object element = args[index];
            if (!(element instanceof SpecialArg)) continue;
            SpecialArg specialArg = (SpecialArg)((Object)element);
            switch (specialArg.ordinal()) {
                case 0: {
                    args[index] = this.fallbackClassRPCSender;
                    continue block5;
                }
                case 1: {
                    args[index] = baseRPC;
                    continue block5;
                }
                case 2: {
                    args[index] = channelSupplier;
                }
            }
        }
    }

    public static enum SpecialArg {
        RPC_SENDER(RPCSender.class),
        RPC_CHAIN_BASE(ChainableRPC.class),
        CHANNEL_SUPPLIER(Supplier.class);

        private static final SpecialArg[] VALUES;
        public static final int SPECIAL_ARG_MAX_INDEX;
        private final Class<?> argType;

        private SpecialArg(Class<?> argType) {
            if (argType == null) {
                throw new NullPointerException("argType is marked non-null but is null");
            }
            this.argType = argType;
        }

        @NonNull
        static SpecialArg fromParamMappingIndex(int paramMappingIndex) {
            int index = -paramMappingIndex - 1;
            if (index >= 0 && index < VALUES.length) {
                return VALUES[index];
            }
            throw new IllegalStateException(String.format("illegal special param mapping index %d", paramMappingIndex));
        }

        @NonNull
        Class<?> argType() {
            return this.argType;
        }

        static {
            VALUES = SpecialArg.values();
            SPECIAL_ARG_MAX_INDEX = -VALUES.length;
        }
    }

    static final class TempRPCInternalInstanceFactory
    extends RPCInternalInstanceFactory {
        private RPCInternalInstanceFactory delegate;

        TempRPCInternalInstanceFactory() {
        }

        public void setDelegate(@NonNull RPCInternalInstanceFactory delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            if (this.delegate == null) {
                this.delegate = delegate;
            }
        }

        @Override
        @NonNull
        public Object constructInstance(@Nullable ChainableRPC baseRPC, @NonNull Supplier<NetworkChannel> channelSupplier, @NonNull Object[] additionalConstructorArgs) {
            if (channelSupplier == null) {
                throw new NullPointerException("channelSupplier is marked non-null but is null");
            }
            if (additionalConstructorArgs == null) {
                throw new NullPointerException("additionalConstructorArgs is marked non-null but is null");
            }
            return this.constructInstance(baseRPC, null, channelSupplier, additionalConstructorArgs);
        }

        @Override
        @NonNull
        public Object constructInstance(@Nullable ChainableRPC baseRPC, @Nullable RPCSender classRPCSender, @NonNull Supplier<NetworkChannel> channelSupplier, @NonNull Object[] additionalConstructorArgs) {
            if (channelSupplier == null) {
                throw new NullPointerException("channelSupplier is marked non-null but is null");
            }
            if (additionalConstructorArgs == null) {
                throw new NullPointerException("additionalConstructorArgs is marked non-null but is null");
            }
            RPCInternalInstanceFactory delegate = this.delegate;
            Preconditions.checkState((delegate != null ? 1 : 0) != 0, (Object)"delegate not yet set");
            return delegate.constructInstance(baseRPC, classRPCSender, channelSupplier, additionalConstructorArgs);
        }
    }
}

