/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.generation;

import com.google.common.hash.Hashing;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCGenerationCache;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCGenerationConstants;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCInternalInstanceFactory;
import eu.cloudnetservice.driver.network.rpc.introspec.RPCClassMetadata;
import eu.cloudnetservice.driver.network.rpc.introspec.RPCMethodMetadata;
import java.lang.classfile.ClassBuilder;
import java.lang.classfile.CodeBuilder;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

final class RPCGenerationContext {
    private final RPCGenerationCache generationCache;
    private final Set<TypeDescriptorField> typeDescriptorFields = new LinkedHashSet<TypeDescriptorField>();
    private final Set<AdditionalInstanceFactoryField> additionalInstanceFactoriesFields = new LinkedHashSet<AdditionalInstanceFactoryField>();
    MethodTypeDesc superclassConstructorDesc;

    public RPCGenerationContext(@NonNull RPCGenerationCache generationCache) {
        if (generationCache == null) {
            throw new NullPointerException("generationCache is marked non-null but is null");
        }
        this.generationCache = generationCache;
    }

    public int additionalInstanceFactoryCount() {
        return this.additionalInstanceFactoriesFields.size();
    }

    @NonNull
    public List<RPCInternalInstanceFactory> additionalInstanceFactories() {
        return this.additionalInstanceFactoriesFields.stream().map(AdditionalInstanceFactoryField::instanceFactory).toList();
    }

    @NonNull
    public String registerAdditionalInstanceFactory(int generationFlags, @NonNull Class<?> superType, @NonNull Class<?> baseImplementation) {
        if (superType == null) {
            throw new NullPointerException("superType is marked non-null but is null");
        }
        if (baseImplementation == null) {
            throw new NullPointerException("baseImplementation is marked non-null but is null");
        }
        RPCClassMetadata targetClassMeta = RPCClassMetadata.introspect(baseImplementation);
        RPCInternalInstanceFactory generatedInstanceFactory = this.generationCache.getOrGenerateImplementation(generationFlags, superType, targetClassMeta);
        return this.registerAdditionalInstanceFactory(superType, generatedInstanceFactory);
    }

    @NonNull
    public String registerAdditionalInstanceFactory(@NonNull Class<?> targetType, @NonNull RPCInternalInstanceFactory factory) {
        if (targetType == null) {
            throw new NullPointerException("targetType is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        AdditionalInstanceFactoryField factoryField = AdditionalInstanceFactoryField.forFactory(targetType, factory);
        this.additionalInstanceFactoriesFields.add(factoryField);
        return factoryField.name();
    }

    @NonNull
    public String registerTypeDescriptorField(@NonNull RPCMethodMetadata methodMetadata) {
        if (methodMetadata == null) {
            throw new NullPointerException("methodMetadata is marked non-null but is null");
        }
        TypeDescriptorField descriptorField = TypeDescriptorField.forMethod(methodMetadata);
        this.typeDescriptorFields.add(descriptorField);
        return descriptorField.name();
    }

    public void applyToClassAndConstructor(@NonNull ClassDesc generatingClass, @NonNull ClassBuilder classBuilder, @NonNull CodeBuilder constructorCode) {
        if (generatingClass == null) {
            throw new NullPointerException("generatingClass is marked non-null but is null");
        }
        if (classBuilder == null) {
            throw new NullPointerException("classBuilder is marked non-null but is null");
        }
        if (constructorCode == null) {
            throw new NullPointerException("constructorCode is marked non-null but is null");
        }
        for (TypeDescriptorField typeDescriptorField : this.typeDescriptorFields) {
            typeDescriptorField.applyToClassAndConstructor(generatingClass, classBuilder, constructorCode);
        }
        int currentFactoryIndex = 1;
        for (AdditionalInstanceFactoryField factoryField : this.additionalInstanceFactoriesFields) {
            factoryField.applyToClassAndConstructor(currentFactoryIndex++, generatingClass, classBuilder, constructorCode);
        }
    }

    private record AdditionalInstanceFactoryField(@NonNull String name, @NonNull Class<?> targetType, @NonNull RPCInternalInstanceFactory instanceFactory) {
        @Generated
        public AdditionalInstanceFactoryField(@NonNull String name, @NonNull Class<?> targetType, @NonNull RPCInternalInstanceFactory instanceFactory) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (targetType == null) {
                throw new NullPointerException("targetType is marked non-null but is null");
            }
            if (instanceFactory == null) {
                throw new NullPointerException("instanceFactory is marked non-null but is null");
            }
        }

        @NonNull
        public static AdditionalInstanceFactoryField forFactory(@NonNull Class<?> targetType, @NonNull RPCInternalInstanceFactory instanceFactory) {
            if (targetType == null) {
                throw new NullPointerException("targetType is marked non-null but is null");
            }
            if (instanceFactory == null) {
                throw new NullPointerException("instanceFactory is marked non-null but is null");
            }
            String hashedName = Hashing.murmur3_128().hashString((CharSequence)targetType.getName(), StandardCharsets.UTF_8).toString();
            String fieldName = String.format("rpc_if_%s", hashedName);
            return new AdditionalInstanceFactoryField(fieldName, targetType, instanceFactory);
        }

        public void applyToClassAndConstructor(int fieldIndex, @NonNull ClassDesc generatingClass, @NonNull ClassBuilder classBuilder, @NonNull CodeBuilder constructorCode) {
            if (generatingClass == null) {
                throw new NullPointerException("generatingClass is marked non-null but is null");
            }
            if (classBuilder == null) {
                throw new NullPointerException("classBuilder is marked non-null but is null");
            }
            if (constructorCode == null) {
                throw new NullPointerException("constructorCode is marked non-null but is null");
            }
            classBuilder.withField(this.name, RPCGenerationConstants.CD_INT_INSTANCE_FACTORY, RPCGenerationConstants.AFM_FIELD_PF);
            int otherParamsCount = RPCInternalInstanceFactory.MTD_BASIC_IMPLEMENTATION_CONSTRUCTOR.parameterCount();
            constructorCode.aload(0).aload(otherParamsCount + fieldIndex).putfield(generatingClass, this.name, RPCGenerationConstants.CD_INT_INSTANCE_FACTORY);
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AdditionalInstanceFactoryField that = (AdditionalInstanceFactoryField)o;
            return Objects.equals(this.targetType, that.targetType);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.targetType);
        }
    }

    private record TypeDescriptorField(@NonNull String name, @NonNull String descriptor) {
        @Generated
        public TypeDescriptorField(@NonNull String name, @NonNull String descriptor) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (descriptor == null) {
                throw new NullPointerException("descriptor is marked non-null but is null");
            }
        }

        @NonNull
        public static TypeDescriptorField forMethod(@NonNull RPCMethodMetadata methodMetadata) {
            if (methodMetadata == null) {
                throw new NullPointerException("methodMetadata is marked non-null but is null");
            }
            String descriptor = methodMetadata.methodType().descriptorString();
            String hashedDescriptor = Hashing.murmur3_128().hashString((CharSequence)descriptor, StandardCharsets.UTF_8).toString();
            String fieldName = String.format("rpc_td_%s_%s", methodMetadata.name(), hashedDescriptor);
            return new TypeDescriptorField(fieldName, descriptor);
        }

        public void applyToClassAndConstructor(@NonNull ClassDesc generatingClass, @NonNull ClassBuilder classBuilder, @NonNull CodeBuilder constructorCode) {
            if (generatingClass == null) {
                throw new NullPointerException("generatingClass is marked non-null but is null");
            }
            if (classBuilder == null) {
                throw new NullPointerException("classBuilder is marked non-null but is null");
            }
            if (constructorCode == null) {
                throw new NullPointerException("constructorCode is marked non-null but is null");
            }
            classBuilder.withField(this.name, RPCGenerationConstants.CD_TYPE_DESC, RPCGenerationConstants.AFM_FIELD_PF);
            constructorCode.aload(0).ldc((ConstantDesc)((Object)this.descriptor)).invokestatic(ConstantDescs.CD_MethodTypeDesc, "ofDescriptor", RPCGenerationConstants.MTD_MTD_OF_DESCRIPTOR, true).putfield(generatingClass, this.name, RPCGenerationConstants.CD_TYPE_DESC);
        }
    }
}

