/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.rpc.defaults.generation;

import eu.cloudnetservice.driver.network.rpc.annotation.RPCInvocationTarget;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCGenerationConstants;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCGenerationContext;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCImplementationGenerator;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCInternalInstanceFactory;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCMethodGenerator;
import eu.cloudnetservice.driver.network.rpc.introspec.RPCMethodMetadata;
import eu.cloudnetservice.driver.util.CodeGenerationUtil;
import java.lang.classfile.CodeBuilder;
import java.lang.classfile.TypeKind;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Constructor;
import java.util.Objects;
import lombok.NonNull;

final class ChainedRPCMethodGenerator
implements RPCMethodGenerator {
    ChainedRPCMethodGenerator() {
    }

    @Override
    public void generate(@NonNull CodeBuilder codeBuilder, @NonNull ClassDesc generatingClass, @NonNull RPCGenerationContext context, @NonNull RPCMethodMetadata targetMethod, @NonNull MethodTypeDesc targetMethodDesc) {
        if (codeBuilder == null) {
            throw new NullPointerException("codeBuilder is marked non-null but is null");
        }
        if (generatingClass == null) {
            throw new NullPointerException("generatingClass is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (targetMethod == null) {
            throw new NullPointerException("targetMethod is marked non-null but is null");
        }
        if (targetMethodDesc == null) {
            throw new NullPointerException("targetMethodDesc is marked non-null but is null");
        }
        RPCMethodMetadata.MethodChainMetadata rpcChainMeta = Objects.requireNonNull(targetMethod.chainMetadata(), "invalid call to chained factory");
        int[] paramMappings = rpcChainMeta.parameterMappings();
        TypeDescriptor.OfField targetReturnType = targetMethod.methodType().returnType();
        Class chainBaseType = (Class)Objects.requireNonNullElse(rpcChainMeta.baseImplementationType(), targetReturnType);
        this.validateConstructorArgumentMapping(paramMappings, chainBaseType, targetMethod);
        int additionalGenFlags = rpcChainMeta.generationFlags();
        String instanceFactoryFieldName = context.registerAdditionalInstanceFactory(additionalGenFlags, (Class<?>)targetReturnType, chainBaseType);
        int chainBaseStoreSlot = this.storeRPCChainBase(codeBuilder, generatingClass, context, targetMethod);
        int extraArgsArrayStoreSlot = this.storeExtraParameterArray(paramMappings, targetMethod.methodType(), codeBuilder);
        ClassDesc returnDescriptor = ClassDesc.ofDescriptor(((Class)targetReturnType).descriptorString());
        codeBuilder.aload(0).getfield(generatingClass, instanceFactoryFieldName, RPCGenerationConstants.CD_INT_INSTANCE_FACTORY).aload(chainBaseStoreSlot).aload(0).getfield(generatingClass, "channel_supplier", RPCGenerationConstants.CD_SUPPLIER).aload(extraArgsArrayStoreSlot).invokevirtual(RPCGenerationConstants.CD_INT_INSTANCE_FACTORY, "constructInstance", RPCGenerationConstants.MTD_INT_INSTANCE_FACTORY_CONSTRUCT).checkcast(returnDescriptor).areturn();
    }

    private int storeRPCChainBase(@NonNull CodeBuilder codeBuilder, @NonNull ClassDesc generatingClass, @NonNull RPCGenerationContext context, @NonNull RPCMethodMetadata targetMethod) {
        if (codeBuilder == null) {
            throw new NullPointerException("codeBuilder is marked non-null but is null");
        }
        if (generatingClass == null) {
            throw new NullPointerException("generatingClass is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (targetMethod == null) {
            throw new NullPointerException("targetMethod is marked non-null but is null");
        }
        String typeDescriptorFieldName = context.registerTypeDescriptorField(targetMethod);
        codeBuilder.aload(0).ldc((ConstantDesc)((Object)targetMethod.name())).aload(0).getfield(generatingClass, typeDescriptorFieldName, RPCGenerationConstants.CD_TYPE_DESC);
        RPCImplementationGenerator.generateObjectArgumentStore(codeBuilder, targetMethod.methodType());
        int chainBaseStoreSlot = codeBuilder.allocateLocal(TypeKind.ReferenceType);
        codeBuilder.invokevirtual(generatingClass, "bridge$rpc$invoke", RPCGenerationConstants.MTD_BRIDGE_RPC_INVOKE).astore(chainBaseStoreSlot);
        return chainBaseStoreSlot;
    }

    private int storeExtraParameterArray(int[] paramMapping, @NonNull MethodType methodType, @NonNull CodeBuilder codeBuilder) {
        if (methodType == null) {
            throw new NullPointerException("methodType is marked non-null but is null");
        }
        if (codeBuilder == null) {
            throw new NullPointerException("codeBuilder is marked non-null but is null");
        }
        int mappingCount = paramMapping.length / 2;
        int extraArgsArrayStoreSlot = codeBuilder.allocateLocal(TypeKind.ReferenceType);
        codeBuilder.ldc((ConstantDesc)Integer.valueOf(mappingCount)).anewarray(ConstantDescs.CD_Object).astore(extraArgsArrayStoreSlot);
        for (int index = 0; index < paramMapping.length; index += 2) {
            int methodParamIndex = paramMapping[index];
            int constructorParamIndex = paramMapping[index + 1];
            codeBuilder.aload(extraArgsArrayStoreSlot).ldc((ConstantDesc)Integer.valueOf(constructorParamIndex));
            if (methodParamIndex >= 0) {
                TypeDescriptor.OfField paramType = methodType.parameterType(methodParamIndex);
                int paramSlot = codeBuilder.parameterSlot(methodParamIndex);
                if (((Class)paramType).isPrimitive()) {
                    TypeKind typeKind = TypeKind.fromDescriptor((CharSequence)((Class)paramType).descriptorString());
                    codeBuilder.loadLocal(typeKind, paramSlot);
                    CodeGenerationUtil.boxPrimitive(codeBuilder, ((Class)paramType).descriptorString());
                    codeBuilder.aastore();
                    continue;
                }
                codeBuilder.aload(paramSlot).aastore();
                continue;
            }
            RPCInternalInstanceFactory.SpecialArg specialArg = RPCInternalInstanceFactory.SpecialArg.fromParamMappingIndex(methodParamIndex);
            codeBuilder.getstatic(RPCGenerationConstants.CD_INT_FACTORY_SPECIAL_ARG, specialArg.name(), RPCGenerationConstants.CD_INT_FACTORY_SPECIAL_ARG).aastore();
        }
        return extraArgsArrayStoreSlot;
    }

    private void validateConstructorArgumentMapping(int[] paramMappings, @NonNull Class<?> chainBaseType, @NonNull RPCMethodMetadata targetMethod) {
        Constructor<?>[] constructors;
        if (chainBaseType == null) {
            throw new NullPointerException("chainBaseType is marked non-null but is null");
        }
        if (targetMethod == null) {
            throw new NullPointerException("targetMethod is marked non-null but is null");
        }
        for (Constructor<?> constructor : constructors = chainBaseType.getDeclaredConstructors()) {
            if (!constructor.isAnnotationPresent(RPCInvocationTarget.class)) continue;
            this.validateConstructorArgumentMapping(paramMappings, targetMethod, constructor);
            return;
        }
        if (paramMappings.length > 0) {
            throw new IllegalStateException(String.format("expected 0 argument mappings for chained return type %s from %s in %s, got %d", ((Class)targetMethod.methodType().returnType()).getName(), targetMethod.name(), targetMethod.definingClass().getName(), paramMappings.length / 2));
        }
    }

    private void validateConstructorArgumentMapping(int[] paramMappings, @NonNull RPCMethodMetadata targetMethod, @NonNull Constructor<?> targetConstructor) {
        if (targetMethod == null) {
            throw new NullPointerException("targetMethod is marked non-null but is null");
        }
        if (targetConstructor == null) {
            throw new NullPointerException("targetConstructor is marked non-null but is null");
        }
        int requiredParameterCount = paramMappings.length / 2;
        if (targetConstructor.getParameterCount() != requiredParameterCount) {
            throw new IllegalStateException(String.format("target constructor in %s for chain implementation of %s in %s has not enough parameters (expected %d, got %d)", targetConstructor.getDeclaringClass().getName(), targetMethod.name(), targetMethod.definingClass().getName(), requiredParameterCount, targetConstructor.getParameterCount()));
        }
        Class<?>[] constructorParamTypes = targetConstructor.getParameterTypes();
        for (int index = 0; index < paramMappings.length; index += 2) {
            int methodParamIndex = paramMappings[index];
            int constructorParamIndex = paramMappings[index + 1];
            if (constructorParamIndex >= constructorParamTypes.length) {
                throw new IllegalStateException(String.format("method %s in %s tries to map to constructor parameter %d which doesn't exist on target constructor in %s", targetMethod.name(), targetMethod.definingClass().getName(), constructorParamIndex, targetConstructor.getDeclaringClass().getName()));
            }
            Class<?> constructorParamType = constructorParamTypes[constructorParamIndex];
            if (methodParamIndex >= 0) {
                TypeDescriptor.OfField methodParamType = targetMethod.methodType().parameterType(methodParamIndex);
                if (constructorParamType.isAssignableFrom((Class<?>)methodParamType)) continue;
                throw new IllegalStateException(String.format("target constructor in %s defines param type %s at index %d, but method %s in %s tried to map param type %s (index %d)", targetConstructor.getDeclaringClass().getName(), constructorParamType.getName(), constructorParamIndex, targetMethod.name(), targetMethod.definingClass().getName(), ((Class)methodParamType).getName(), methodParamIndex));
            }
            RPCInternalInstanceFactory.SpecialArg specialArg = RPCInternalInstanceFactory.SpecialArg.fromParamMappingIndex(methodParamIndex);
            if (constructorParamType.isAssignableFrom(specialArg.argType())) continue;
            throw new IllegalStateException(String.format("target constructor in %s defines param type %s at index %d, but method %s in %s tried to map special type %s", targetConstructor.getDeclaringClass().getName(), constructorParamType.getName(), constructorParamIndex, targetMethod.name(), targetMethod.definingClass().getName(), specialArg.argType().getName()));
        }
    }
}

