/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.protocol.defaults;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.protocol.QueryPacketManager;
import java.time.Duration;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class DefaultQueryPacketManager
implements QueryPacketManager {
    protected final NetworkChannel networkChannel;
    protected final Cache<UUID, CompletableFuture<Packet>> waitingHandlers;

    public DefaultQueryPacketManager(@NonNull NetworkChannel networkChannel) {
        if (networkChannel == null) {
            throw new NullPointerException("networkChannel is marked non-null but is null");
        }
        this.networkChannel = networkChannel;
        this.waitingHandlers = Caffeine.newBuilder().expireAfterWrite(Duration.ofHours(8L)).removalListener(this.newRemovalListener()).build();
    }

    @Override
    @NonNull
    public NetworkChannel networkChannel() {
        return this.networkChannel;
    }

    @Override
    public long waitingHandlerCount() {
        return this.waitingHandlers.estimatedSize();
    }

    @Override
    public boolean hasWaitingHandler(@NonNull UUID queryUniqueId) {
        if (queryUniqueId == null) {
            throw new NullPointerException("queryUniqueId is marked non-null but is null");
        }
        return this.waitingHandlers.getIfPresent((Object)queryUniqueId) != null;
    }

    @Override
    @Nullable
    public CompletableFuture<Packet> waitingHandler(@NonNull UUID queryUniqueId) {
        if (queryUniqueId == null) {
            throw new NullPointerException("queryUniqueId is marked non-null but is null");
        }
        CompletableFuture task = (CompletableFuture)this.waitingHandlers.getIfPresent((Object)queryUniqueId);
        if (task != null) {
            this.waitingHandlers.invalidate((Object)queryUniqueId);
        }
        return task;
    }

    @Override
    @NonNull
    public CompletableFuture<Packet> sendQueryPacket(@NonNull Packet packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        CompletableFuture<Packet> responseTask = new CompletableFuture<Packet>();
        UUID queryUniqueId = Objects.requireNonNullElseGet(packet.uniqueId(), UUID::randomUUID);
        this.waitingHandlers.put((Object)queryUniqueId, responseTask);
        packet.uniqueId(queryUniqueId);
        this.networkChannel.sendPacketSync(packet);
        return responseTask;
    }

    @NonNull
    protected RemovalListener<UUID, CompletableFuture<Packet>> newRemovalListener() {
        return (uUID, value, cause) -> {
            if (cause != RemovalCause.EXPLICIT && value != null) {
                value.completeExceptionally(new TimeoutException());
            }
        };
    }
}

