/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.codec;

import eu.cloudnetservice.driver.network.netty.NettyUtil;
import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerAdapter;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.util.concurrent.Future;
import io.netty5.util.concurrent.Promise;
import io.netty5.util.concurrent.PromiseCombiner;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class VarInt32FramePrepender
extends ChannelHandlerAdapter {
    public static final VarInt32FramePrepender INSTANCE = new VarInt32FramePrepender();

    @NonNull
    public Future<Void> write(@NonNull ChannelHandlerContext ctx, @NonNull Object msg) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (msg == null) {
            throw new NullPointerException("msg is marked non-null but is null");
        }
        if (msg instanceof Buffer) {
            Buffer packetDataBuffer = (Buffer)msg;
            int length = packetDataBuffer.readableBytes();
            int encodedLengthFieldLength = NettyUtil.varIntBytes(length);
            Buffer lengthBuffer = ctx.bufferAllocator().allocate(encodedLengthFieldLength);
            NettyUtil.writeVarInt(lengthBuffer, length);
            PromiseCombiner combiner = new PromiseCombiner(ctx.executor());
            combiner.add(ctx.write((Object)lengthBuffer));
            combiner.add(ctx.write(msg));
            Promise promise = ctx.newPromise();
            combiner.finish(promise);
            return promise.asFuture();
        }
        return ctx.write(msg);
    }

    public boolean isSharable() {
        return true;
    }
}

