/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty.buffer;

import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.netty.NettyUtil;
import eu.cloudnetservice.driver.network.netty.buffer.NettyImmutableDataBuf;
import eu.cloudnetservice.driver.network.rpc.defaults.object.DefaultObjectMapper;
import io.netty5.buffer.Buffer;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.function.BiConsumer;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class NettyMutableDataBuf
extends NettyImmutableDataBuf
implements DataBuf.Mutable {
    public NettyMutableDataBuf(@NonNull Buffer buffer) {
        super(buffer);
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
    }

    @Override
    @NonNull
    public DataBuf.Mutable writeBoolean(boolean b) {
        this.buffer.writeBoolean(b);
        return this;
    }

    @Override
    @NonNull
    public DataBuf.Mutable writeInt(int integer) {
        this.buffer.writeInt(integer);
        return this;
    }

    @Override
    @NonNull
    public DataBuf.Mutable writeByte(byte b) {
        this.buffer.writeByte(b);
        return this;
    }

    @Override
    @NonNull
    public DataBuf.Mutable writeShort(short s) {
        this.buffer.writeShort(s);
        return this;
    }

    @Override
    @NonNull
    public DataBuf.Mutable writeLong(long l) {
        this.buffer.writeLong(l);
        return this;
    }

    @Override
    @NonNull
    public DataBuf.Mutable writeFloat(float f) {
        this.buffer.writeFloat(f);
        return this;
    }

    @Override
    @NonNull
    public DataBuf.Mutable writeDouble(double d) {
        this.buffer.writeDouble(d);
        return this;
    }

    @Override
    @NonNull
    public DataBuf.Mutable writeChar(char c) {
        this.buffer.writeChar(c);
        return this;
    }

    @Override
    @NonNull
    public DataBuf.Mutable writeByteArray(byte[] b) {
        return this.writeByteArray(b, b.length);
    }

    @Override
    @NonNull
    public DataBuf.Mutable writeByteArray(byte[] b, int amount) {
        int sizeBytes = NettyUtil.varIntBytes(amount);
        this.buffer.ensureWritable(sizeBytes + amount);
        NettyUtil.writeVarInt(this.buffer, amount);
        this.buffer.writeBytes(b, 0, amount);
        return this;
    }

    @Override
    @NonNull
    public DataBuf.Mutable writeUniqueId(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        this.buffer.ensureWritable(16);
        return this.writeLong(uuid.getMostSignificantBits()).writeLong(uuid.getLeastSignificantBits());
    }

    @Override
    @NonNull
    public DataBuf.Mutable writeString(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("string is marked non-null but is null");
        }
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        return this.writeByteArray(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public DataBuf.Mutable writeDataBuf(@NonNull DataBuf buf) {
        if (buf == null) {
            throw new NullPointerException("buf is marked non-null but is null");
        }
        buf.startTransaction();
        try {
            int readableBytes = buf.readableBytes();
            int sizeBytes = NettyUtil.varIntBytes(readableBytes);
            this.buffer.ensureWritable(sizeBytes + readableBytes);
            NettyUtil.writeVarInt(this.buffer, readableBytes);
            this.buffer.writeBytes(((NettyImmutableDataBuf)buf).buffer);
        }
        finally {
            buf.redoTransaction().release();
        }
        return this;
    }

    @Override
    @NonNull
    public DataBuf.Mutable writeObject(@Nullable Object obj) {
        return DefaultObjectMapper.DEFAULT_MAPPER.writeObject(this, obj);
    }

    @Override
    @NonNull
    public <T> DataBuf.Mutable writeNullable(@Nullable T object, @NonNull BiConsumer<DataBuf.Mutable, T> handlerWhenNonNull) {
        if (handlerWhenNonNull == null) {
            throw new NullPointerException("handlerWhenNonNull is marked non-null but is null");
        }
        this.writeBoolean(object != null);
        if (object != null) {
            handlerWhenNonNull.accept(this, (DataBuf.Mutable)object);
        }
        return this;
    }

    @Override
    @NonNull
    public DataBuf.Mutable ensureWriteable(int bytes) {
        this.buffer.ensureWritable(bytes);
        return this;
    }

    @Override
    @NonNull
    public DataBuf asImmutable() {
        return new NettyImmutableDataBuf(this.buffer);
    }
}

