/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.netty;

import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.netty.NettyNetworkChannel;
import eu.cloudnetservice.driver.network.protocol.BasePacket;
import eu.cloudnetservice.driver.network.protocol.Packet;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.channel.SimpleChannelInboundHandler;
import java.io.IOException;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public abstract class NettyNetworkHandler
extends SimpleChannelInboundHandler<BasePacket> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyNetworkHandler.class);
    protected volatile NettyNetworkChannel channel;

    public void channelInactive(@NonNull ChannelHandlerContext ctx) throws Exception {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (!(ctx.channel().isActive() && ctx.channel().isOpen() && ctx.channel().isWritable())) {
            this.channel.handler().handleChannelClose(this.channel);
            ctx.channel().close();
            this.channels().remove(this.channel);
        }
    }

    public void channelExceptionCaught(@NonNull ChannelHandlerContext ctx, @NonNull Throwable cause) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (cause == null) {
            throw new NullPointerException("cause is marked non-null but is null");
        }
        if (!(cause instanceof IOException)) {
            LOGGER.error("Exception in network handler", cause);
        }
    }

    public void channelReadComplete(@NonNull ChannelHandlerContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        ctx.flush();
    }

    protected void messageReceived(@NonNull ChannelHandlerContext ctx, @NonNull BasePacket msg) {
        if (ctx == null) {
            throw new NullPointerException("ctx is marked non-null but is null");
        }
        if (msg == null) {
            throw new NullPointerException("msg is marked non-null but is null");
        }
        if (msg.prioritized()) {
            this.doHandlePacket(msg);
        } else {
            this.packetDispatcher().execute(() -> this.doHandlePacket(msg));
        }
    }

    protected void doHandlePacket(@NonNull BasePacket packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        try {
            CompletableFuture<Packet> task;
            UUID uuid = packet.uniqueId();
            if (uuid != null && (task = this.channel.queryPacketManager().waitingHandler(uuid)) != null) {
                task.complete(packet);
                return;
            }
            if (this.channel.handler().handlePacketReceive(this.channel, packet) && this.channel.packetRegistry().handlePacket(this.channel, packet)) {
                return;
            }
            packet.content().forceRelease();
        }
        catch (Exception exception) {
            LOGGER.error("Exception whilst handling packet {}", (Object)packet, (Object)exception);
        }
    }

    @NonNull
    protected abstract Collection<NetworkChannel> channels();

    @NonNull
    protected abstract Executor packetDispatcher();
}

