/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.chunk.network;

import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.chunk.ChunkedPacketHandler;
import eu.cloudnetservice.driver.network.chunk.data.ChunkSessionInformation;
import eu.cloudnetservice.driver.network.chunk.defaults.ChunkedSessionRegistry;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.protocol.PacketListener;
import java.util.function.Function;
import lombok.NonNull;

public class ChunkedPacketListener
implements PacketListener {
    private final ChunkedSessionRegistry sessionRegistry;
    private final Function<ChunkSessionInformation, ChunkedPacketHandler> handlerFactory;

    public ChunkedPacketListener(@NonNull ChunkedSessionRegistry sessionRegistry, @NonNull Function<ChunkSessionInformation, ChunkedPacketHandler> handlerFactory) {
        if (sessionRegistry == null) {
            throw new NullPointerException("sessionRegistry is marked non-null but is null");
        }
        if (handlerFactory == null) {
            throw new NullPointerException("handlerFactory is marked non-null but is null");
        }
        this.sessionRegistry = sessionRegistry;
        this.handlerFactory = handlerFactory;
    }

    @Override
    public void handle(@NonNull NetworkChannel channel, @NonNull Packet packet) throws Exception {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        DataBuf packetContent = packet.content();
        ChunkSessionInformation sessionInfo = packetContent.readObject(ChunkSessionInformation.class);
        int chunkIndex = packetContent.readInt();
        ChunkedPacketHandler sessionHandler = this.sessionRegistry.getOrCreateSession(sessionInfo, this.handlerFactory);
        boolean transferComplete = sessionHandler.handleChunkPart(chunkIndex, packetContent);
        if (transferComplete) {
            this.sessionRegistry.completeSession(sessionInfo.sessionUniqueId());
        }
    }
}

