/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.chunk.network;

import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.buffer.DataBufFactory;
import eu.cloudnetservice.driver.network.chunk.data.ChunkSessionInformation;
import eu.cloudnetservice.driver.network.netty.NettyUtil;
import eu.cloudnetservice.driver.network.protocol.BasePacket;
import lombok.NonNull;

public final class ChunkedPacket
extends BasePacket {
    private ChunkedPacket(@NonNull DataBuf dataBuf) {
        super(2, dataBuf);
        if (dataBuf == null) {
            throw new NullPointerException("dataBuf is marked non-null but is null");
        }
    }

    @NonNull
    public static ChunkedPacket createFullChunk(int chunkIndex, byte[] sourceData, @NonNull ChunkSessionInformation sessionInfo) {
        if (sessionInfo == null) {
            throw new NullPointerException("sessionInfo is marked non-null but is null");
        }
        int sourceDataLengthSize = NettyUtil.varIntBytes(sourceData.length);
        int transferBytes = 5 + sourceDataLengthSize + sourceData.length + sessionInfo.packetSizeBytes();
        DataBuf.Mutable informationBuffer = DataBufFactory.defaultFactory().createWithExpectedSize(transferBytes).writeObject(sessionInfo).writeInt(chunkIndex).writeBoolean(false).writeByteArray(sourceData);
        return new ChunkedPacket(informationBuffer);
    }

    @NonNull
    public static ChunkedPacket createFinalChunk(int chunkIndex, int readBytes, byte[] sourceData, @NonNull ChunkSessionInformation sessionInfo) {
        if (sessionInfo == null) {
            throw new NullPointerException("sessionInfo is marked non-null but is null");
        }
        int sourceDataLengthSize = NettyUtil.varIntBytes(readBytes);
        int transferBytes = 5 + sourceDataLengthSize + readBytes + sessionInfo.packetSizeBytes();
        DataBuf.Mutable informationBuffer = DataBufFactory.defaultFactory().createWithExpectedSize(transferBytes).writeObject(sessionInfo).writeInt(chunkIndex).writeBoolean(true).writeByteArray(sourceData, readBytes);
        return new ChunkedPacket(informationBuffer);
    }
}

