/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.chunk.event;

import eu.cloudnetservice.driver.channel.ChannelMessage;
import eu.cloudnetservice.driver.event.EventListener;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.event.events.channel.ChannelMessageReceiveEvent;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.buffer.DataBufFactory;
import eu.cloudnetservice.driver.network.chunk.ChunkedPacketSender;
import eu.cloudnetservice.driver.network.chunk.event.FileQueryRequestEvent;
import jakarta.inject.Inject;
import java.util.UUID;
import lombok.NonNull;

public final class FileQueryChannelMessageListener {
    private final EventManager eventManager;

    @Inject
    public FileQueryChannelMessageListener(@NonNull EventManager eventManager) {
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        this.eventManager = eventManager;
    }

    @NonNull
    private static DataBuf constructRequestResponse(boolean transferStarted) {
        return DataBufFactory.defaultFactory().createWithExpectedSize(1).writeBoolean(transferStarted);
    }

    @EventListener
    public void handleFileQueryRequest(@NonNull ChannelMessageReceiveEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        NetworkChannel channel = event.networkChannel();
        ChannelMessage request = event.channelMessage();
        if (!(event.query() && request.channel().equals("cloudnet:internal") && request.message().equals("chunked_query_file"))) {
            return;
        }
        DataBuf requestData = request.content();
        int chunkSize = requestData.readInt();
        UUID chunkedSessionId = requestData.readUniqueId();
        String requestedDataId = requestData.readString();
        FileQueryRequestEvent requestEvent = this.eventManager.callEvent(new FileQueryRequestEvent(requestedDataId, requestData));
        ChunkedPacketSender.Builder responseHandlerBuilder = requestEvent.responseHandler();
        if (responseHandlerBuilder == null) {
            DataBuf responseData = FileQueryChannelMessageListener.constructRequestResponse(false);
            event.binaryResponse(responseData);
        } else {
            responseHandlerBuilder.toChannels(channel).chunkSize(chunkSize).transferChannel("query:dummy").sessionUniqueId(chunkedSessionId).build().transferChunkedData();
            DataBuf responseData = FileQueryChannelMessageListener.constructRequestResponse(true);
            event.binaryResponse(responseData);
        }
    }
}

