/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.driver.network.chunk.defaults.builder;

import com.google.common.base.Preconditions;
import eu.cloudnetservice.common.io.FileUtil;
import eu.cloudnetservice.driver.channel.ChannelMessage;
import eu.cloudnetservice.driver.channel.ChannelMessageTarget;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.buffer.DataBufFactory;
import eu.cloudnetservice.driver.network.chunk.ChunkedFileQueryBuilder;
import eu.cloudnetservice.driver.network.chunk.data.ChunkSessionInformation;
import eu.cloudnetservice.driver.network.chunk.defaults.ChunkedSessionRegistry;
import eu.cloudnetservice.driver.network.chunk.defaults.DefaultFileChunkedPacketHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import lombok.NonNull;

public class DefaultChunkedFileQueryBuilder
implements ChunkedFileQueryBuilder {
    private static final DataBuf EMPTY_BUFFER = DataBufFactory.defaultFactory().createWithExpectedSize(0);
    private String dataIdentifier;
    private ChannelMessageTarget dataSource;
    private Consumer<DataBuf.Mutable> messageBufferConfigurator;
    private int chunkSize = 0x3200000;

    @Override
    @NonNull
    public ChunkedFileQueryBuilder chunkSize(int chunkSize) {
        Preconditions.checkArgument((chunkSize > 0 ? 1 : 0) != 0, (Object)"chunk size must be greater than 0");
        this.chunkSize = chunkSize;
        return this;
    }

    @Override
    @NonNull
    public ChunkedFileQueryBuilder dataIdentifier(@NonNull String dataIdentifier) {
        if (dataIdentifier == null) {
            throw new NullPointerException("dataIdentifier is marked non-null but is null");
        }
        Preconditions.checkArgument((!dataIdentifier.isBlank() ? 1 : 0) != 0, (Object)"data identifier cannot be empty");
        this.dataIdentifier = dataIdentifier;
        return this;
    }

    @Override
    @NonNull
    public ChunkedFileQueryBuilder requestFromNode(@NonNull String nodeId) {
        if (nodeId == null) {
            throw new NullPointerException("nodeId is marked non-null but is null");
        }
        this.dataSource = ChannelMessageTarget.of(ChannelMessageTarget.Type.NODE, nodeId);
        return this;
    }

    @Override
    @NonNull
    public ChunkedFileQueryBuilder requestFromService(@NonNull String serviceName) {
        if (serviceName == null) {
            throw new NullPointerException("serviceName is marked non-null but is null");
        }
        this.dataSource = ChannelMessageTarget.of(ChannelMessageTarget.Type.SERVICE, serviceName);
        return this;
    }

    @Override
    @NonNull
    public ChunkedFileQueryBuilder configureMessageBuffer(@NonNull Consumer<DataBuf.Mutable> bufferConfigurer) {
        if (bufferConfigurer == null) {
            throw new NullPointerException("bufferConfigurer is marked non-null but is null");
        }
        this.messageBufferConfigurator = bufferConfigurer;
        return this;
    }

    @Override
    @NonNull
    public CompletableFuture<InputStream> query() {
        Preconditions.checkNotNull((Object)this.dataIdentifier, (Object)"no data id provided");
        Preconditions.checkNotNull((Object)this.dataSource, (Object)"no data source provided");
        UUID sessionId = UUID.randomUUID();
        DataBuf.Mutable queryBuffer = DataBuf.empty().writeInt(this.chunkSize).writeUniqueId(sessionId).writeString(this.dataIdentifier);
        if (this.messageBufferConfigurator != null) {
            this.messageBufferConfigurator.accept(queryBuffer);
        }
        CompletableFuture responseFuture = new CompletableFuture();
        ChunkedSessionRegistry sessionRegistry = InjectionLayer.boot().instance(ChunkedSessionRegistry.class);
        ChunkSessionInformation sessionInfo = new ChunkSessionInformation(this.chunkSize, sessionId, "query:dummy", EMPTY_BUFFER);
        DefaultFileChunkedPacketHandler handler = new DefaultFileChunkedPacketHandler(sessionInfo, (chunkSessionInformation, stream) -> !responseFuture.complete(stream));
        sessionRegistry.registerSession(sessionId, handler);
        ChannelMessage channelMessage = ChannelMessage.builder().channel("cloudnet:internal").message("chunked_query_file").target(this.dataSource).buffer(queryBuffer).build();
        return channelMessage.sendSingleQueryAsync().thenCompose(response -> {
            DataBuf responseData = response.content();
            if (responseData.readBoolean()) {
                return responseFuture;
            }
            throw new IllegalStateException("unable to start chunked data transfer");
        });
    }

    @Override
    @NonNull
    public CompletableFuture<Path> queryToTempFile() {
        Path tempFile = FileUtil.createTempFile();
        return this.queryToPath(tempFile);
    }

    @Override
    @NonNull
    public CompletableFuture<Path> queryToPath(@NonNull Path target) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        return this.query().thenApply(stream -> {
            Path path;
            block8: {
                InputStream inputStream = stream;
                try {
                    FileUtil.copy((InputStream)stream, (Path)target);
                    path = target;
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException exception) {
                        throw new UncheckedIOException(exception);
                    }
                }
                inputStream.close();
            }
            return path;
        });
    }

    static {
        EMPTY_BUFFER.release();
    }
}

